#!/bin/bash


VIDEO_IN=$1;
AUDIO_S=$2;
AUDIO_T=$3;
AUDIO_C=$4;
TAG=$5;

mkdir -p .tmp 

echo "Converting two mono files to stereo files"

sox $AUDIO_S -c2 .tmp/source.wav;
sox $AUDIO_T -c2 .tmp/target.wav;
sox $AUDIO_C -c2 .tmp/converted.wav;

cd .tmp

sox source.wav out11.wav avg 1.0,0.0,0.0,0.0
sox source.wav out12.wav avg 0.0,1.0,0.0,0.0

sox target.wav out21.wav avg 1.0,0.0,0.0,0.0
sox target.wav out22.wav avg 0.0,1.0,0.0,0.0

sox converted.wav out31.wav avg 1.0,0.0,0.0,0.0
sox converted.wav out32.wav avg 0.0,1.0,0.0,0.0

#Source audio
soxmix out11.wav out12.wav out1.wav

#Target audio
soxmix out21.wav out22.wav out2.wav

#Converted audio
soxmix out31.wav out32.wav out3.wav

#Mixed audio S-T
soxmix out11.wav out22.wav out4.wav

#Mixed audio S-C
soxmix out11.wav out32.wav out5.wav

#Mixed audio T-C
soxmix out21.wav out32.wav out6.wav


for f in out?.wav; do
    g=${f/wav/mp3}
    echo "Creating $g file"
    lame --quiet $f -o $g 
done

cd ..


DIR_OUT=${VIDEO_IN/.avi/}_${TAG}
mkdir -p ${DIR_OUT}
cp .tmp/out1.mp3 ${DIR_OUT}/source.mp3
cp .tmp/out2.mp3 ${DIR_OUT}/target.mp3
cp .tmp/out3.mp3 ${DIR_OUT}/converted.mp3

VIDEO_OUT=${DIR_OUT}/${VIDEO_IN/.avi/};

echo "Merging audio & video: $VIDEO_OUT"
avimerge -o ${VIDEO_OUT}_Source.avi -i $VIDEO_IN -p .tmp/out1.mp3 

avimerge -o ${VIDEO_OUT}_Target.avi -i $VIDEO_IN -p .tmp/out2.mp3 

avimerge -o ${VIDEO_OUT}_Converted.avi -i $VIDEO_IN -p .tmp/out3.mp3 

avimerge -o ${VIDEO_OUT}_Mixed_S_T.avi -i $VIDEO_IN -p .tmp/out4.mp3 

avimerge -o ${VIDEO_OUT}_Mixed_S_C.avi -i $VIDEO_IN -p .tmp/out5.mp3 

avimerge -o ${VIDEO_OUT}_Mixed_T_C.avi -i $VIDEO_IN -p .tmp/out6.mp3


rm -rf .tmp

echo "Done!"