function labels = CC4M_FindCluster(DIR,p,file)
%find the labels for the vectors contained in file, according to the
%cluster structure found in DIR that has been created with the parameter
%set in p
%
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project

p = CC4M_ParamInit(p);%set parameters to standard values if not set

open([file(1:length(file)-4) '_' num2str(p.winlength) '_' ...
    num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']);
mfcc = ans.mfcc;
open(fullfile(DIR,['Clusters_' p.clust_meth '_' num2str(p.num_clusters) '_' num2str(p.num_ceps_coeffs) '_' ...
            num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']));
centres = ans.centres;
labels = findlabels(centres',mfcc')';