function [w_mfcc,w_delta,w_ddelta,w_E]=compute_weights(DIR,n);

%%  This function computes the inverse of the variance of each coefficients (mffc's, delta's, delta-delta and log(Energy))
%%  DIR is the name of a repertory that contains one or more repertories containing the features
%%  n is the number of features used. 
%%  The features need to be in the following order:
%%  log(E)      mfcc (n)        delta(log(E))       delta-mfcc's (n)        ddelta(log(E))          ddelta-mfcc's (n)

D = dir(DIR);k=0;
for i=1:length(D)
    if(D(i).isdir & ~(D(i).name(1) == '.'))
        k=k+1;
        mfccDir(k)=D(i);
    end
end

if(k>0)
     for i=1:k
        ClassName{i} = fullfile( DIR, mfccDir(i).name) ;
        TL=dir([ClassName{i} '/*.mat']);
        for j=1:length(TL)
            AllList{i}.file{j}=fullfile(DIR,mfccDir(i).name,TL(j).name);
             
            load(sprintf('%s',AllList{i}.file{j}));
            if(j==1 & k==1)
                all=mfcc;
            else
                all=[all mfcc];
            end
        end
    end
end

VAR=var(all');
INV_VAR=1./VAR;
w_mfcc=INV_VAR(2:n+1)';
w_delta=INV_VAR(n+3:2*n+2)';
w_ddelta=INV_VAR(2*n+4:end)';
w_E=[INV_VAR(1) INV_VAR(n+2) INV_VAR(2*n+3)]';