function cdist=concatenation_distance(frame1,frame2,options,w_mfcc,w_delta,w_ddelta,w_E)

% [cdist] = concatenation_distance2(frame1,frame2,options,w_mfcc,w_delta,w_ddelta,w_E)
%
% PARAMETERS
% options (see below)
% w_mfcc is the weights vector for the MFCC's coefficients (a column vector with same number of elements than the MFCC's)
% w_delta is the weights vector for the delta-MFCC's coefficients (same length)
% w_delta is the weights vector for the ddelta-MFCC's coefficients (same length)
% w_E is the weight vector for the three following coefficients log(E) delta log(E)  ddelta log(E)
%
%  The default value for all the weights is 1.
%
% About the options parameter:
%  you can use any combination of the following parameters :
%    'e' = log(E)
%    'f' = delta(log(E))
%    'g' = deltadelta(log(E))
%    'm' = MFCC's
%    'd' = delta
%    'D' = deltadelta
%
% e.g. if options = 'dem', the features used for the concatenation cost
% will be [log(E) MFCC's delta].
% The default value of options is 'efgmdD' (all features are used)
% If the user entered an empty string for options (options = '')
% the options will be the default value ('efgmdD')

if ((frame1.index==frame2.index-1)  & strcmp(frame1.name,frame2.name))
    cdist=0;
else
% %     % CHECKING - useless if the function is called properly
% %     if mod(length(frame1.mfcc),3)~=0
% %         display('Error : mfcc format is not a multiple of 3')
% %         cdist = Inf;
% %         return
% %     end
% %     
% %     if length(frame1.mfcc)~=length(frame2.mfcc)
% %         display('Error : frame1 and frame2 don''t have the same dimension')
% %         cdist = Inf;
% %         return
% %     end
% % 
% %     if nargin<3 options = 'efgmdD'; end
% %     if nargin<4 w_mfcc = ones(n,1); end
% %     if nargin<5 w_delta = ones(n,1); end
% %     if nargin<6 w_ddelta = ones(n,1); end
% %     if nargin<7 w_E = ones(3,1); end

    n = length(frame1.mfcc)/3 - 1;
    feat1 = [];
    feat2 = [];

    if isempty(options)
        options = 'efgmdD';
    end

    if any(options=='e')
        feat1 = w_E(1)*frame1.mfcc(1);
        feat2 = w_E(1)*frame2.mfcc(1);
    end

    if any(options=='f')
        feat1 = [feat1;w_E(2)*frame1.mfcc(n+2)];
        feat2 = [feat2;w_E(2)*frame2.mfcc(n+2)];
    end

    if any(options=='g')
        feat1 = [feat1;w_E(3)*frame1.mfcc(2*n+3)];
        feat2 = [feat2;w_E(3)*frame2.mfcc(2*n+3)];
    end

    if any(options=='m')
        feat1 = [feat1;w_mfcc.*frame1.mfcc(2:n+1)];
        feat2 = [feat2;w_mfcc.*frame2.mfcc(2:n+1)];
    end

    if any(options=='d')
        feat1 = [feat1;w_delta.*frame1.mfcc(n+3:2*n+2)];
        feat2 = [feat2;w_delta.*frame2.mfcc(n+3:2*n+2)];
    end

    if any(options=='D')
        feat1 = [feat1;w_ddelta.*frame1.mfcc(2*n+4:end)];
        feat2 = [feat2;w_ddelta.*frame2.mfcc(2*n+4:end)];
    end

    cdist= sqrt(sum((feat2-feat1).^2));
end