function cdist=concatenation_distance_old(frame1,frame2,w_mfcc,w_delta,w_ddelta,w_E);

%w_mfcc is the weights vector for the MFCC's coefficients (a column vector with same number of elements than the MFCC's)
%w_delta is the weights vector for the delta-MFCC's coefficients (same length)
%w_delta is the weights vector for the ddelta-MFCC's coefficients (same length)
%n is the number of MFCC's coefficients used
%w_E is the weight vector for the three following coefficients log(E) delta log(E)  ddelta log(E)


n=length(w_mfcc);
if ((frame1.index==frame2.index-1)  & (frame1.name==frame2.name))   
        cdist=0;   
else   
    mfcc1=w_mfcc.*frame1.mfcc(2:n+1);
    delta1=w_delta.*frame1.mfcc(n+3:2*(n+1));
    ddelta1=w_ddelta.*frame1.mfcc(2*(n+2):3*(n+1));
    
    mfcc2=w_mfcc.*frame2.mfcc(2:n+1);
    delta2=w_delta.*frame2.mfcc(n+3:2*(n+1));
    ddelta2=w_ddelta.*frame2.mfcc(2*(n+2):3*(n+1));
    
    all1=[mfcc1;delta1;ddelta1];
    all2=[mfcc2;delta2;ddelta2];
    cdist=sqrt(sum((all1-all2).^2));
end

