% [stateSequence] = mexUnitSelection(source,cluster,target,weights,NBEST);
% 
%     source is a 2D matrix containing the features (e.g. MFCC) of the source (y_prime)
%         dimension : [numberOfFeatures x numberOfFrames]
% 
%     cluster is an array of cells containing information about the clustering of the target database :
%         dimension : [1 x numberOfClusters]
%         each cell represents one cluster and contains 3 fields :
%             center : 1D matrix of double [numberOfMFCC x 1] containing the features of 
%                      the center of the cluster
%             frames : 1D matrix of int [numberOfFramesInTheCluster] 
%                      containing the index of the database (awb) frames which are in this cluster.
%             size : int [1 x 1] containing the number of database frames which are in this cluster.
% 
%     target is an array of cells containing information about the features of the target database :
%         dimension : [1 x numberOfFramesInDatabase]
%         each cell represents one frame and contains 3 fields :
%             mfcc : 1D matrix of double [numberOfMFCC x 1] containing the features (mfcc) 
%                    of each frame of the database.
%             name : a string containing the name of the file from which the frame comes from 
%                    (e.g. : 'a0082.wav')
%             index : an integer value [1 x 1] containing the index of that frame in that file 
%                    (e.g. : 123, meaning the 123rd frame of 'a0082.wav')
% 
%     weights (optional) : a 1D matrix of double value containing the weights for the weighted euclidian distance
% 
%     NBEST (optional) : an integer value. It's the number of states to select for the n-best 
% 
%     out : a 1D matrix [numberOfFrames x 1]
%           It contains the index of the frames of the database selected by the Viterbi algorithm
%           (e.g. : 1234 means the 1234th frame of the database 
%            --> the 1234th element of the target structure
%            --> you can get the frame using target.name(1234) and target.index(1234)

error('mex-file not found') %in case this help file is called instead of the mex-file