function tdist=target_distance_old(frame1,frame2,options,w_mfcc,w_delta,w_ddelta,w_E)

%PARAMETERS
%options (see below)
%w_mfcc is the weights vector for the MFCC's coefficients (a column vector with same number of elements than the MFCC's)
%w_delta is the weights vector for the delta-MFCC's coefficients (same length)
%w_delta is the weights vector for the ddelta-MFCC's coefficients (same length)
%w_E is the weight vector for the three following coefficients log(E) delta log(E)  ddelta log(E)

%About the options parameter:
%   'a' =only MFCC's
%   'b' =log(E) + MFCC's
%   'c' =log(E) + MFCC's + d(log(E)) + delta 
%   'd' =log(E) + MFCC's + d(log(E)) + delta + delta delta
%   'e' =MFCC's + delta
%   'f' =MFCC's + delta + delta delta

n=length(w_mfcc);

%features computation - need optimization
E1=w_E(1)*frame1.mfcc(1);
mfcc1=w_mfcc.*frame1.mfcc(2:n+1);
dE1=w_E(2)*frame1.mfcc(n+2);
delta1=w_delta.*frame1.mfcc(n+3:2*n+2);
ddE1=w_E(3)*frame1.mfcc(2*n+3);
ddelta1=w_ddelta.*frame1.mfcc(2*n+4:end);

E2=w_E(1)*frame2.mfcc(1);
mfcc2=w_mfcc.*frame2.mfcc(2:n+1);
dE2=w_E(2)*frame2.mfcc(n+2);
delta2=w_delta.*frame2.mfcc(n+3:2*n+2);
ddE2=w_E(3)*frame2.mfcc(2*n+3);
ddelta2=w_ddelta.*frame2.mfcc(2*n+4:end);


if (options=='a')
    feat1=mfcc1;
    feat2=mfcc2;
    
elseif (options=='b')
    feat1=[E1;mfcc1];
    feat2=[E2;mfcc2];
    
elseif (options=='c')
    feat1=([E1;mfcc1;dE1;delta1]);
    feat2=([E2;mfcc2;dE2;delta2]);
    
elseif (options=='d')
    feat1=([E1;mfcc1;dE1;delta1;ddE1;ddelta1]);
    feat2=([E2;mfcc2;dE2;delta2;ddE2;ddelta2]);
    
elseif (options=='e')
    feat1=([mfcc1;delta1]);
    feat2=([mfcc2;delta2]);
    
elseif (options=='f')
    feat1=([mfcc1;delta1;ddelta1]);
    feat2=([mfcc2;delta2;ddelta2]); 
end

tdist= sqrt(sum((feat2-feat1).^2));