function unit_sequence=tts_select_units(DIR,mfcc)
%function unit_sequence=tts_select_units(DIR,p,file)

% Partially based on code from the project: TTSBOX, a corpus-based speech
% synthesizer for Genglish. Copyright and license follows.
%
% Copyright (c) 2004 Faculte Polytechnique de Mons-Thierry Dutoit 
%                    - Slovak Academy of Science - Milos Cernak
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation

% simply for testing purposes
NBEST = 25;
w_mfcc = 1;
w_delta = 1;
w_ddelta = 1;
w_E = 1;

  p.num_clusters = 39;
  p.num_ceps_coeffs = 12;
  p.nrg = 1;
  p.use_deltas = 1;
  
  p = CC4M_ParamInit(p);
  
  % centres & mfcc_all
  load(fullfile(DIR,['Clusters_' p.clust_meth '_' num2str(p.num_clusters) ...
		     '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' ...
		     num2str(p.use_deltas) '.mat'])); 
  
  % mfcc
  open([file(1:length(file)-4) '_' num2str(p.winlength) '_' ...
	num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']); 

  labels = findlabels(centres',mfcc')';

  unit_lattice = zeros(NBEST, length(labels));
  I = zeros(NBEST,length(labels)-1);
  
  for i=1:length(labels),
      if (i>1) index_previous=index_current; end;

      index_current = find(mfcc_all.cluster==labels(i));
      tdist = zeros(length(index_current),1);
      for n=1:length(index_current)
          frame1.mfcc = mfcc(:,i);
          frame2.mfcc = mfcc_all.mfcc(:,index_current(n));
          tdist(n)=target_distance(frame1,frame2,'m', w_mfcc,w_delta,w_ddelta,w_E);
      end

      %pruning : retain the NBEST best units (in terms of target cost)
      %N.B. : there's another possibility of pruning : select the NBEST of
      %       the overall_cost_upto_current_target vector. --Alexis
      [tdist, index]=sort(tdist);
      if length(index)>NBEST,
          index_current=index_current(index(1:NBEST));
      end

      % do partial viterbi
      % induction
      overall_cost_upto_current_target = zeros(size(index_current));
      for u=1:length(index_current)
          if (i>1)
              frame2.name = mfcc_all.name(index_current(u));
              frame2.index = mfcc_all.index(index_current(u));
              frame2.mfcc = mfcc_all.mfcc(:,index_current(u));
              overall_cost_partial = zeros(size(index_previous));
              for v=1:length(index_previous)
                  frame1.name = mfcc_all.name(index_previous(v));
                  frame1.index = mfcc_all.index(index_previous(v));
                  frame1.mfcc = mfcc_all.mfcc(:,index_previous(v));
                  overall_cost_partial(v) = overall_cost_upto_previous_target(v) ...
                      + concatenation_distance(frame1,frame2,'mdD',w_mfcc,w_delta,w_ddelta,w_E);
              end;

              % find min and indices
              [value,index]=min(overall_cost_partial);
              overall_cost_upto_current_target(u)=value + tdist(u);
              I(u,i-1)=index;    % fill indice's matrix for backtracking
              clear overall_cost_partial;
          else
              overall_cost_upto_current_target(u)=tdist(u);
          end;
      end;

      overall_cost_upto_previous_target=overall_cost_upto_current_target;
      unit_lattice(1:length(index_current),i)=index_current';
  end;

  % viterbi - backtracking
  [value,index]=min(overall_cost_upto_current_target);
  for i=length(labels):-1:2
    unit_sequence(i,1)=unit_lattice(index,i);
    index=I(index,i-1);
  end;
  unit_sequence(1,1)=unit_lattice(index,1);
