function Ct = GMM_MF(C, EM, SDT) 
%
% Transformation of input data accordig to the continuous
% probabilistic mapping function using GMM (Yannis Stylianou et al. IEEE SAP, 1998)
% 
% INPUT:
%	C the input data [size_of_vectors, number_of_vectors]
%       EM structure, containing:
%	Mix, mi, and Sd: results from the EM algorithm:
%		Mix: posteriori probabilities
%		  m: mean values
%	      Sdinv: inverse covariance matrices (diagonal matrices)
%              detS: Determinant of the diagonal covariance matrix
%
%       SDT structure, containing:
%       ni, and Gamma: results from the training of the mapping function
%		 ni: Mean values
%	      Gamma: Rotation matrix
%
%
% Yannis Stylianou, 31/07/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%

[p,fr]=size(C);
Ct = zeros(size(C));

% size of vectors and number of mixtures
[p,m] = size([EM.mi]);

for ll=1:fr

   vec = C(:,ll);
   
   % compute likelihood
   for i=1:m
      trs = vec-EM(i).mi;
      Pt(i) = EM(i).Mix * EM(i).detS * exp(-0.5*( trs'*EM(i).Sdinv*trs ) );
   end
   Pt = Pt/sum(Pt);
   %keyboard;pause;
   %dist = 1./sum(vec(:,ones(1,m))-[EM.mi].^2);
   %Pt = dist/sum(dist);
   
   % Conversion of the input data
  sumi = 0;
  for i=1:m
      sumi = sumi+Pt(i)*( SDT(i).ni + SDT(i).Gamma*EM(i).Sdinv*(vec-EM(i).mi) );
  end
  Ct(:,ll)= sumi;
end
