function Transform(flIn, flOut)
%
% It exttracts the MFCCs from the input speech file (flIn),
% Transform the coeffieicnts according to a continuous probabilistic
% approach based on GMM (Stylianou et al. IEEE SAP 1998)
% and saves the tansformed coefficients into the output parameters
% file: flOut (where a standard extension is added: _transf.mfcc
% Also the non transformed MFCCs are saved in the file flOUT with extension
% just: .mffcc
%
% It uses a GMM representation for the input speech space saved in files:
% ../../IDTW/source_td.aligned3.mfcc (_em.dsc and _em.res)
% and a mapping function which is saved after training into:
% ../../IDTW/Trans3_TD2AWB (_sdt.dsc and _sdt.res)
%
% Makesure sure that these files are in your path
%
% Example:
%		Transform('arctic_a0005', 'Validation/arctic_a0005');   
%
% 
% Yannis Stylianou, 01/08/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%

% directories for the speech files:
%dIn = '../../DataSet/eNTERFACE06_us_td_arctic/Validation/wav/';
%dIn = '../../DataSet/eNTERFACE06_us_td_arctic/Evaluation/wav/';
dIn = '../../DataSet/eNTERFACE06_us_td_arctic/Training/wav/';

% For STFT features for both sounds (75% window overlap)
NFFT=512;
cv = 0.75;
NOVERLAP = round(cv*NFFT);

% For mfcc
p.fs = 16000;
p.visu = 0;
p.fft_size = NFFT;
p.hopsize = round((1-cv)*NFFT);
p.num_ceps_coeffs = 20;
p.use_first_coeff = 0;
p.male_filt_bank = [20 16000 40];
p.dB_max = 96;
p.nrg = 0;

% Load EM structure
flEM = 'source_td.aligned3.mfcc';
EM = read_dEM(flEM);

% Load SDT structure
flSDT = 'Trans3_TD2AWB';
SDT = read_dSDT(flSDT);

% read speech file
[d1, fs] = wavread([dIn flIn '.wav']);

% compute MFCC
disp('compute MFCCs ...')
C = Comp_MFCC(d1,p);

% transform using GMM-based maping function 
% (Stylianou et al., IEEE SAP 1998)
disp('Transform MFCCs ....');
Ct = GMM_MF(C, EM, SDT);

% reshape data
C = reshape(C,1,size(C,1)*size(C,2));
Ct = reshape(Ct,1,size(Ct,1)*size(Ct,2));

% save the initial and the transformed MFFCs
fp = fopen([flOut '.mfcc'],'wb');
fwrite(fp, C, 'float');
fclose(fp);
fp = fopen([flOut '_transf.mfcc'],'wb');
fwrite(fp, Ct, 'float');
fclose(fp);

