function SDT = read_dSDT(fl)
%
% SDT: builds the mapping function 
% Read into the SDT structure, the results of the SDT using diagonal covariance
% matrices
%
% SDT Structure: 
%		ni: mean vectors
%	     Gamma: Rotation matrices
%
% Input filename should NOT include the standard used extension ('_sdt.res');
%
%
% Yannis Stylianou, 31/07/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%


% read the descriptor file
%-> m, p
fp = fopen([fl '_sdt.dsc'], 'r');
v = sscanf(fgetl(fp),'%d');
p = v(2);m=v(3);
fclose(fp);

fp = fopen([fl '_sdt.res'], 'rb');
Ni = fread(fp, m*p, 'float');
GammaD = fread(fp, m*p, 'float');
%keyboard;pause;
Ni = reshape(Ni, m, p)';
GammaD = reshape(GammaD, m, p)'; %p,m);
fclose(fp);

% build structure
for i=1:m
  SDT(i).ni = Ni(:,i);
  SDT(i).Gamma = sparse(diag(GammaD(:,i)));
end
