#include "mex.h"

void AutoCor(r, WindowLength, Signal, Lag, MODE)

int WindowLength, Lag, MODE;
double *Signal, *r;

{
 int l;
 double *SumPtr, *CurrentSamplePtr, *LagSamplePtr, *LastSamplePtr;

 SumPtr = r;
 LastSamplePtr = Signal + WindowLength;

 for(l = 0; l <= Lag; l++)
  {
	CurrentSamplePtr = Signal;
	LagSamplePtr     = Signal + l;
	*SumPtr          = 0.0;

	while ( LagSamplePtr < LastSamplePtr )
	   *SumPtr += *CurrentSamplePtr++ * *LagSamplePtr++;
	if(MODE == 1)
		*SumPtr = (*SumPtr) / (WindowLength - l);
	
	if(MODE == 2)
		*SumPtr = (*SumPtr) / WindowLength;
	
	SumPtr++;
  }
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  int WindowLength, Lag, MODE;
  double *Signal, *r;

  Lag = (int)mxGetScalar(prhs[2]);
  WindowLength = (int)mxGetScalar(prhs[0]);
  MODE = (int)mxGetScalar(prhs[3]);

  plhs[0] = mxCreateDoubleMatrix(1,Lag+1,0);
  r = mxGetPr(plhs[0]);

  Signal = mxGetPr(prhs[1]);

 AutoCor(r, WindowLength, Signal, Lag, MODE);
}
