function LPCas_byexample(filename, V_source, AR_target)

%
% function LPCas_byexample(filename, V_source, AR_target)
%
% filename is expected to be a wav file
%
% LPC Analysis and Synthesis with OLA. AR coefficients are expected
% to be modified using the "example" method:
% For each frame, a vector with mfcc coefficients is estimated; then the computed
% vector is projected to the space of the Source speaker (V_source). Next
% the association with an AR filter coefficients can be retrived since there are ALIGNED
% data between the Source and the Target speaker (from whom the AR_target data have been constructed)
%
% Example for test it: 
% ---------------------
% use target speaker the same as the source speaker (thierry)
% and use a file already analyzed (from the training data). It should produced the
% original signal, if everything works well.
%
% OrderMffc = 20;
% fp=fopen('../DTW/source_td.aligned.mfcc','rb');
% V = fread(fp,'float');
% V = reshape(V,OrderMffc,length(V)/OrderMffc);
% fclose(fp);
% flAR = '../DTW/source_td.aligned.ar';
% fl1 = '../DataSet/eNTERFACE06_us_td_arctic/Training/wav/arctic_a0030.wav';
%
% LPCas_byexample(fl1, V, flAR);
% 
% check if the file ../DataSet/eNTERFACE06_us_td_arctic/Training/wav/arctic_a0030.wav
% sounds the same as the output generated speech file: test.wav
%
% RESULTS:
% For (Yannis) it sounds OK! => Matlab program works fine
%
% A second check:
%------------------
% It would be to produce Thierry's signal from the Validation directory:
% V is as before
% flAR = '../DTW/source_td.aligned.ar'; (as before)
% fl1 = '../DataSet/eNTERFACE06_us_td_arctic/Validation/wav/arctic_a0005.wav'
% LPCas_byexample(fl1, V, flAR);
%
% RESULTS:
% NOT BAD! (Yannis: I am really surprised!) => it seems we have enough data (at least for this file)
% to generate 'unknown' Source spectral envelopes (i.e., using the excitation from Thierry)
%
% Let's do the same for Alan's data, for an 'unseen' speech file:
% ---------------------------------------------------------------
% OrderMffc = 20;
% fp=fopen('../DTW/target_awb.aligned.mfcc','rb');
% V = fread(fp,'float');
% V = reshape(V,OrderMffc,length(V)/OrderMffc);
% fclose(fp);
% flAR = '../DTW/target_awb.aligned.ar';
% 'Unseen' sentence:
% fl1 = '../DataSet/cmu_us_awb_arctic/wav/arctic_a0005.wav';
% LPCas_byexample(fl1, V, flAR);
%
%
% A REAL example for run it: (it sounds terrible)
% ------------------------------------------------
%
% OrderMffc = 20;
% fp=fopen('../DTW/source_td.aligned.mfcc','rb');
% V = fread(fp,'float');
% V = reshape(V,OrderMffc,length(V)/OrderMffc);
% fclose(fp);
%
% flAR = '../DTW/target_awb.aligned.ar';
% fl1 = '../DataSet/eNTERFACE06_us_td_arctic/Validation/wav/arctic_a0005.wav'
% LPCas_byexample(fl1, V, flAR);
%
%
% Yannis Stylianou, 29/07/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%

% For STFT features for both sounds (75% window overlap)
NFFT=512;
cv = 0.75;
NOVERLAP = round(cv*NFFT);

% For mfcc
p.fs = 16000;
p.visu = 0;
p.fft_size = NFFT;
p.hopsize = round((1-cv)*NFFT);
p.num_ceps_coeffs = 20;
p.use_first_coeff = 0;
p.male_filt_bank = [20 16000 40];
p.dB_max = 96;
p.nrg = 0;

% for LPC
OrderLPC = 20;
FrameRate = round((1-cv)*NFFT);


% read input file
[sig,Fs] = wavread(filename);

% compute MFCC
C = Comp_MFCC(sig,p);

% get the corresponding AR coefficents from the Target speaker
% given the input mfcc coefficients from the current speech file
Arcf = getAR(C,V_source, AR_target, OrderLPC);
%load AR_temp.mat; % for testing m-files

% for OLA
Buffer = 0;

Horizon = NFFT;
Shift = FrameRate;
Horizon2 = 2*FrameRate;
Win = hanning(Horizon);
WinS = hanning(Horizon2);

Crop = 0.5*(Horizon-Horizon2)+1:0.5*(Horizon+Horizon2);

Lsig = length(sig);
slice = 1:Horizon;
Nfr = floor((Lsig-Horizon)/Shift)+1;

% if everything is correct Nfr should be equal to size(Ar,2);
if(Nfr~=size(Arcf,2))
   disp('Problem in the number of frames');
   keyboard;pause;
end

SNR = zeros(1,Nfr);
OutputSig = zeros(size(sig));
Ws = 1:Shift;
Ws =Ws+Crop(1)-1;

for l=1:Nfr
 [l, Nfr]
   % perform again analysis and collect SNR data
   sigLPC = Win.*sig(slice);
   en = sum(sigLPC.^2);
   sigLPC = filter([1 -0.9],1, sigLPC); % pre-emphasis
   r = AutoCor(Horizon,sigLPC,OrderLPC, 0); % Autocorrelation
   [a,k] = Del_Genin(r, OrderLPC);  % basically: the Levinson Durbin method
   G = sqrt(r*a');  % gain
   ex = filter(a,G,sigLPC);  % excitation
   
   % get SNR:
   SNR(l) = compSNR(a(2:length(a)),Arcf(:,l));
   
   % replace estimated AR coefficients
   a(2:length(a)) = Arcf(:,l)';
   
 % synthesize
   s = filter(G,a,ex);
   s = filter(1,[1 -0.9],s);
   ens = sum(s.^2);
   g = sqrt(en/ens);
   s = s*g;
   
   % since I have a different size of window in analysis and in synthesis:
   s = s./Win;
   s = s(Crop).*WinS;
   s(1:Shift) = s(1:Shift) + Buffer;
   Buffer = s(Shift+1:Horizon2); 
   %fwrite(fpout, s(1:Shift), 'short');
   OutputSig(Ws) =s(1:Shift);
   Ws = Ws+Shift;
   slice = slice+Shift;

if(0)
 l
   figure(1);
   [H1,W] = freqz(1,a,512);H1=20*log10(abs(H1));
   [H2,W]= freqz(1,am,512);H2=20*log10(abs(H2));
   plot(W, H1);on;plot(W, H2,'g');off
   figure(2);
    subplot(211);plot(sigLPC);
    subplot(212);plot(s);
   pause;
end

end
disp('OK');
wavwrite(OutputSig,Fs,'test.wav');

%keyboard;pause;
