function A = getAR(C, V, AR_target, OrderLPC)
%
% For each Input vector of matrix of MFCCs, C,
% perform its projection to the space of V to get the best
% mathing vectors (representatives) in the V space (containing MFCCs). Then,
% get the appropriate AR coefficients from a AR file
% which is aligned in time with the V-space. The output contains the
% coefficents of the corresponding AR  filters.
%
% The output matrix, A, has dimensions:  OrderLPC by size(C,2)
%
% Yannis Stylianou, 29/07/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%

% open AR aligned data for the Target speaker:
fpAR_target = fopen(AR_target, 'rb');

if(nargin<4)
  OrderLPC = 20;
end

A = zeros(OrderLPC, length(C));

for i=1:length(C)
   SM = simmx(C(:,i),V);         % project the vector to the space
   [Cor,id] = max(abs(SM));      % find the index of the best matching vector
   
   if(length(id)>1) % in case we have many times the same vector (it may happen)
         id = id(1);
   end
   
   pos = 4*(id-1)*OrderLPC;    % float -> 4 bytes, files start from 0
   fseek(fpAR_target, pos, 'bof');
     
   % read AR coeff.
   A(:,i) = fread(fpAR_target, OrderLPC, 'float');
end

fclose(fpAR_target);
