function EM = read_dEM(fl)
%
% Read into the EM structure, the results of the EM using diagonal covariance
% matrices
%
% EM Structure: 
%	       Mix: a-posteriori probabilities
%		mi: mean vectors
%	     Sdinv: inverse diagonal covariance matrix
%             detS: Determinant of the diagonal covariance matrix
%
% Input filename should NOT include the standard used extension ('_em.res');
%
%
% Yannis Stylianou, 31/07/2006
% University of Crete, Computer Science Dept., Multimedia Informatics Lab
%
% yannis@csd.uoc.gr
%

% read the descriptor file
%-> m, p
fp = fopen([fl '_em.dsc'], 'r');
v = sscanf(fgetl(fp),'%d');
v = sscanf(fgetl(fp),'%d'); % read the 2nd line
m = v(2);p=v(3);
fclose(fp);

fp = fopen([fl '_em.res'], 'rb');
Mix = fread(fp, m, 'float');
mi = fread(fp, m*p, 'float');
 mi = reshape(mi, p,m);
Sd = fread(fp, m*p, 'float');
 Sd = reshape(Sd,p,m);
fclose(fp);

% build structure
for i=1:m
  EM(i).Mix = Mix(i);
  EM(i).mi = mi(:,i);
  EM(i).Sdinv = sparse(diag(1./Sd(:,i)));
  EM(i).detS = 1/sqrt(prod(Sd(:,i)));
end



