/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Host
extends GenericObject {
    protected static final int HOSTNAME = 1;
    protected static final int IPV4ADDRESS = 2;
    protected static final int IPV6ADDRESS = 3;
    protected String hostname;
    protected int addressType;
    private InetAddress inetAddress;

    public Host() {
        this.addressType = 1;
    }

    public Host(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null host name");
        }
        this.hostname = string;
        if (this.isIPv6Address(string)) {
            this.addressType = 3;
        }
        this.addressType = 2;
    }

    public Host(String string, int n) {
        this.addressType = n;
        this.hostname = string.trim().toLowerCase();
    }

    public String encode() {
        if (this.addressType == 3 && !this.isIPv6Reference(this.hostname)) {
            return "[" + this.hostname + "]";
        }
        return this.hostname;
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Host host = (Host)object;
        return host.hostname.equals(this.hostname);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAddress() {
        return this.hostname;
    }

    public String getIpAddress() {
        String string = null;
        if (this.hostname == null) {
            return null;
        }
        if (this.addressType == 1) {
            try {
                if (this.inetAddress == null) {
                    this.inetAddress = InetAddress.getByName(this.hostname);
                }
                string = this.inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.dbgPrint("Could not resolve hostname " + unknownHostException);
            }
        } else {
            string = this.hostname;
        }
        return string;
    }

    public void setHostname(String string) {
        this.inetAddress = null;
        this.addressType = this.isIPv6Address(string) ? 3 : 1;
        if (string != null) {
            this.hostname = string.trim().toLowerCase();
        }
    }

    public void setHostAddress(String string) {
        this.inetAddress = null;
        this.addressType = this.isIPv6Address(string) ? 3 : 2;
        if (string != null) {
            this.hostname = string.trim();
        }
    }

    public void setAddress(String string) {
        this.setHostAddress(string);
    }

    public boolean isHostname() {
        return this.addressType == 1;
    }

    public boolean isIPAddress() {
        return this.addressType != 1;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.hostname == null) {
            return null;
        }
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        this.inetAddress = InetAddress.getByName(this.hostname);
        return this.inetAddress;
    }

    private boolean isIPv6Address(String string) {
        return string != null && string.indexOf(58) != -1;
    }

    private boolean isIPv6Reference(String string) {
        return string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']';
    }
}

