/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class LogWriter {
    public static final int TRACE_NONE = 0;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_EXCEPTION = 17;
    public static final int TRACE_DEBUG = 32;
    private String logFileName = "debuglog.txt";
    private PrintWriter printWriter;
    private PrintStream traceWriter = System.out;
    public static boolean needsLogging = false;
    private int lineCount;
    private static final PrintStream trace = System.out;
    protected static int traceLevel = 0;

    public void logStackTrace() {
        if (needsLogging) {
            this.checkLogFile();
            if (this.printWriter != null) {
                this.println("------------ Traceback ------");
                this.logException(new Exception());
                this.println("----------- End Traceback ------");
            }
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void logException(Throwable throwable) {
        if (needsLogging) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.checkLogFile();
            if (this.printWriter != null) {
                throwable.printStackTrace(printWriter);
            }
            printWriter.close();
            this.println(stringWriter.toString());
        }
    }

    public void logThrowable(Throwable throwable) {
        if (needsLogging) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.checkLogFile();
            if (this.printWriter != null) {
                throwable.printStackTrace(printWriter);
            }
            printWriter.close();
            this.println(stringWriter.toString());
        }
    }

    public void logTrace(Throwable throwable) {
        if (needsLogging) {
            this.checkLogFile();
            this.logException(new Exception(throwable.getMessage()));
        }
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public synchronized void logMessage(String string, String string2) {
        if (needsLogging) {
            try {
                File file = new File(string2);
                if (!file.exists()) {
                    file.createNewFile();
                    this.printWriter = null;
                }
                FileWriter fileWriter = new FileWriter(string2, true);
                PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
                printWriter.println(" ---------------------------------------------- ");
                printWriter.println(string);
                printWriter.close();
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void checkLogFile() {
        if (this.printWriter != null) {
            return;
        }
        if (this.logFileName == null) {
            return;
        }
        try {
            File file = new File(this.logFileName);
            if (!file.exists()) {
                file.createNewFile();
                this.printWriter = null;
            }
            if (this.printWriter == null) {
                FileWriter fileWriter = new FileWriter(this.logFileName, true);
                this.printWriter = new PrintWriter((Writer)fileWriter, true);
                this.printWriter.println("<debug>");
                this.printWriter.println("<![CDATA[ ");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void println(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++this.lineCount;
        }
        this.checkLogFile();
        if (this.printWriter != null) {
            this.printWriter.println(string);
        }
        ++this.lineCount;
    }

    public void logMessage(String string) {
        if (!needsLogging) {
            return;
        }
        this.checkLogFile();
        this.println(string);
    }

    public void setTraceLevel(int n) {
        traceLevel = n;
    }

    public int getTraceLevel() {
        return traceLevel;
    }
}

