/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;

public class NameValue
extends GenericObject {
    protected boolean isQuotedString;
    protected String separator;
    protected String quotes;
    protected String name;
    protected Object value;

    public NameValue() {
        this.name = null;
        this.value = null;
        this.separator = "=";
        this.quotes = "";
    }

    public NameValue(String string, Object object) {
        this.name = string;
        this.value = object;
        this.separator = "=";
        this.quotes = "";
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setQuotedValue() {
        this.isQuotedString = true;
        this.quotes = "\"";
    }

    public boolean isValueQuoted() {
        return this.isQuotedString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public String encode() {
        if (this.name != null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                return this.name + this.separator + this.quotes + genericObject.encode() + this.quotes;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                return this.name + this.separator + genericObjectList.encode();
            }
            return this.name + this.separator + this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name == null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject genericObject = (GenericObject)this.value;
                return genericObject.encode();
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList genericObjectList = (GenericObjectList)this.value;
                return genericObjectList.encode();
            }
            return this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name != null && this.value == null) {
            return this.name;
        }
        return "";
    }

    public Object clone() {
        NameValue nameValue = (NameValue)super.clone();
        if (this.value != null) {
            nameValue.value = NameValue.makeClone(this.value);
        }
        return nameValue;
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        NameValue nameValue = (NameValue)object;
        if (this == nameValue) {
            return true;
        }
        if (this.name == null && nameValue.name != null || this.name != null && nameValue.name == null) {
            return false;
        }
        if (this.name != null && nameValue.name != null && this.name.compareToIgnoreCase(nameValue.name) != 0) {
            return false;
        }
        if (this.value != null && nameValue.value == null || this.value == null && nameValue.value != null) {
            return false;
        }
        if (this.value == nameValue.value) {
            return true;
        }
        if (this.value instanceof String) {
            if (this.isQuotedString) {
                return this.value.equals(nameValue.value);
            }
            String string = (String)this.value;
            String string2 = (String)nameValue.value;
            return string.compareToIgnoreCase(string2) == 0;
        }
        return this.value.equals(nameValue.value);
    }
}

