/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import java.text.ParseException;
import java.util.Vector;

public class StringTokenizer {
    protected String buffer;
    protected int ptr;
    protected int savedPtr;

    public StringTokenizer() {
    }

    public StringTokenizer(String string) {
        this.buffer = string;
        this.ptr = 0;
    }

    public String nextToken() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.ptr < this.buffer.length()) {
            if (this.buffer.charAt(this.ptr) == '\n') {
                stringBuffer.append(this.buffer.charAt(this.ptr));
                ++this.ptr;
                break;
            }
            stringBuffer.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        return stringBuffer.toString();
    }

    public boolean hasMoreChars() {
        return this.ptr < this.buffer.length();
    }

    public static boolean isHexDigit(char c) {
        if (StringTokenizer.isDigit(c)) {
            return true;
        }
        char c2 = Character.toUpperCase(c);
        return c2 == 'A' || c2 == 'B' || c2 == 'C' || c2 == 'D' || c2 == 'E' || c2 == 'F';
    }

    public static boolean isAlpha(char c) {
        boolean bl = Character.isUpperCase(c) || Character.isLowerCase(c);
        return bl;
    }

    public static boolean isDigit(char c) {
        boolean bl = Character.isDigit(c);
        return bl;
    }

    public String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) != '\n') {
            stringBuffer.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        if (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) == '\n') {
            stringBuffer.append('\n');
            ++this.ptr;
        }
        return stringBuffer.toString();
    }

    public String peekLine() {
        int n = this.ptr;
        String string = this.getLine();
        this.ptr = n;
        return string;
    }

    public char lookAhead() throws ParseException {
        return this.lookAhead(0);
    }

    public char lookAhead(int n) throws ParseException {
        if (this.ptr + n < this.buffer.length()) {
            return this.buffer.charAt(this.ptr + n);
        }
        return '\u0000';
    }

    public char getNextChar() throws ParseException {
        if (this.ptr >= this.buffer.length()) {
            throw new ParseException(this.buffer + " getNextChar: End of buffer", this.ptr);
        }
        return this.buffer.charAt(this.ptr++);
    }

    public void consume() {
        this.ptr = this.savedPtr;
    }

    public void consume(int n) {
        this.ptr += n;
    }

    public Vector getLines() {
        Vector<String> vector = new Vector<String>();
        while (this.hasMoreChars()) {
            String string = this.getLine();
            vector.addElement(string);
        }
        return vector;
    }

    public String getNextToken(char c) throws ParseException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c2 = this.lookAhead(0)) != c) {
            if (c2 == '\u0000') {
                throw new ParseException("EOL reached", 0);
            }
            stringBuffer.append(this.buffer.charAt(this.ptr));
            this.consume(1);
        }
        return stringBuffer.toString();
    }

    public static String getSDPFieldName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            int n = string.indexOf("=");
            string2 = string.substring(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return string2;
    }
}

