/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.NistSipMessageFactoryImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Router;

public class SipStackImpl
extends SIPTransactionStack
implements SipStack {
    private Hashtable listeningPoints;
    private LinkedList sipProviders;
    private String outboundProxy;
    protected String routerPath;
    protected EventScanner eventScanner;
    protected boolean reEntrantListener;
    protected boolean stripRouteHeader;
    protected boolean dialogSupport;
    static /* synthetic */ Class class$javax$sip$SipStack;
    static /* synthetic */ Class class$java$lang$String;

    protected SipStackImpl() {
        NistSipMessageFactoryImpl nistSipMessageFactoryImpl = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(nistSipMessageFactoryImpl);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.eventScanner = new EventScanner(this);
    }

    protected void reInit() {
        super.reInit();
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.eventScanner = new EventScanner(this);
    }

    public SipStackImpl(Properties properties) throws PeerUnavailableException {
        this();
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string8 = properties.getProperty("javax.sip.IP_ADDRESS");
        try {
            if (string8 == null) {
                throw new PeerUnavailableException("address not specified");
            }
            super.setHostAddress(string8);
            super.setRealHostAddress(string8);
        }
        catch (UnknownHostException unknownHostException) {
            throw new PeerUnavailableException("bad address " + string8);
        }
        String string9 = properties.getProperty("javax.sip.STACK_NAME");
        if (string9 == null) {
            throw new PeerUnavailableException("stack name is missing");
        }
        super.setStackName(string9);
        String string10 = properties.getProperty("javax.sip.ROUTER_PATH");
        if (string10 == null) {
            string10 = "gov.nist.javax.sip.stack.DefaultRouter";
        }
        String string11 = properties.getProperty("javax.sip.OUTBOUND_PROXY");
        try {
            Class<?> clazz = Class.forName(string10);
            object4 = new Class[]{class$javax$sip$SipStack == null ? (class$javax$sip$SipStack = SipStackImpl.class$("javax.sip.SipStack")) : class$javax$sip$SipStack, class$java$lang$String == null ? (class$java$lang$String = SipStackImpl.class$("java.lang.String")) : class$java$lang$String};
            object3 = clazz.getConstructor((Class<?>)object4);
            object2 = new Object[]{this, string11};
            object = (Router)((Constructor)object3).newInstance(object2);
            super.setRouter((Router)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PeerUnavailableException("Cound not instantiate router - check constructor", (Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PeerUnavailableException("Could not instantiate router", (Throwable)exception);
        }
        if (properties.containsKey("gov.nist.javax.sip.NETWORK_LAYER")) {
            object4 = properties.getProperty("gov.nist.javax.sip.NETWORK_LAYER");
            try {
                object3 = Class.forName((String)object4);
                object2 = ((Class)object3).getConstructor(new Class[0]);
                this.networkLayer = (NetworkLayer)object2.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + (String)object4);
            }
        }
        if ((object4 = properties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            object3 = new StringTokenizer((String)object4);
            object2 = new LinkedList();
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object = ((StringTokenizer)object3).nextToken(":");
                if (((String)object).equalsIgnoreCase("BYE") || ((String)object).equalsIgnoreCase("ACK") || ((String)object).equalsIgnoreCase("OPTIONS")) {
                    throw new PeerUnavailableException("Bad extension method " + (String)object);
                }
                this.addExtensionMethod((String)object);
            }
        }
        if ((object3 = properties.getProperty("javax.sip.RETRANSMISSION_FILTER")) != null && ("true".equalsIgnoreCase(((String)object3).trim()) || "on".equalsIgnoreCase(((String)object3).trim()))) {
            this.retransmissionFilter = true;
        }
        if ((object2 = properties.getProperty("gov.nist.javax.sip.DEBUG_LOG")) != null) {
            this.setDebugLogFileName((String)object2);
        }
        if ((object = properties.getProperty("gov.nist.javax.sip.TRACE_LEVEL")) != null) {
            try {
                int n = Integer.parseInt((String)object);
                if (n == 32) {
                    LogWriter.needsLogging = true;
                }
                this.serverLog.setTraceLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("WARNING Bad integer " + (String)object);
                System.out.println("logging dislabled ");
                this.serverLog.setTraceLevel(0);
            }
        }
        if ((string7 = properties.getProperty("gov.nist.javax.sip.BAD_MESSAGE_LOG")) != null) {
            this.badMessageLog = string7;
        }
        if ((string6 = properties.getProperty("gov.nist.javax.sip.SERVER_LOG")) != null) {
            this.serverLog.setProperties(properties);
        }
        this.serverLog.checkLogFile();
        String string12 = properties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS");
        if (string12 != null) {
            try {
                this.maxConnections = new Integer(string12);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("max connections - bad value " + numberFormatException.getMessage());
            }
        }
        if ((string5 = properties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = new Integer(string5);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("thread pool size - bad value " + numberFormatException.getMessage());
            }
        }
        if ((string4 = properties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.transactionTableSize = new Integer(string4);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("transaction table size - bad value " + numberFormatException.getMessage());
            }
        }
        this.cacheServerConnections = true;
        String string13 = properties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
        if (string13 != null && "false".equalsIgnoreCase(string13.trim())) {
            this.cacheServerConnections = false;
        }
        this.cacheClientConnections = true;
        String string14 = properties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
        if (string14 != null && "false".equalsIgnoreCase(string14.trim())) {
            this.cacheClientConnections = false;
        }
        if ((string3 = properties.getProperty("gov.nist.javax.sip.READ_TIMEOUT")) != null) {
            try {
                int n = Integer.parseInt(string3);
                if (n >= 100) {
                    this.readTimeout = n;
                } else {
                    System.out.println("Value too low " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Bad read timeout " + string3);
            }
        }
        if ((string2 = properties.getProperty("gov.nist.javax.sip.STUN_SERVER")) != null) {
            int n = string2.indexOf(58);
            if (n == -1) {
                this.stunServerAddress = string2;
                this.stunServerPort = 3478;
            } else {
                this.stunServerAddress = string2.substring(0, n);
                string = string2.substring(n + 1).trim();
                try {
                    this.stunServerPort = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.stunServerPort = 3478;
                }
            }
        }
        String string15 = properties.getProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE");
        try {
            if (string15 != null) {
                this.maxMessageSize = new Integer(string15);
                if (this.maxMessageSize < 4096) {
                    this.maxMessageSize = 4096;
                }
            } else {
                this.maxMessageSize = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("maxMessageSize - bad value " + numberFormatException.getMessage());
        }
        string = properties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER");
        this.reEntrantListener = string != null && "true".equals(string);
        String string16 = properties.getProperty("gov.nist.javax.sip.STRIP_ROUTE_HEADER");
        this.stripRouteHeader = true;
        this.stripRouteHeader = string16 == null ? true : "true".equals(string16);
        String string17 = properties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT");
        this.dialogSupport = string17 == null ? true : !"false".equals(string17);
    }

    public synchronized ListeningPoint createListeningPoint(int n, String string) throws TransportNotSupportedException, InvalidArgumentException {
        String string2;
        ListeningPointImpl listeningPointImpl;
        if (string == null) {
            throw new NullPointerException("null transport");
        }
        if (n <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(string.equalsIgnoreCase("UDP") || string.equalsIgnoreCase("TLS") || string.equalsIgnoreCase("TCP"))) {
            throw new TransportNotSupportedException("bad transport " + string);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInit();
        }
        if ((listeningPointImpl = (ListeningPointImpl)this.listeningPoints.get(string2 = ListeningPointImpl.makeKey(this.stackAddress, n, string))) != null) {
            return listeningPointImpl;
        }
        try {
            MessageProcessor messageProcessor = this.createMessageProcessor(n, string);
            listeningPointImpl = new ListeningPointImpl(this, n, string);
            listeningPointImpl.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(listeningPointImpl);
            this.listeningPoints.put(string2, listeningPointImpl);
            return listeningPointImpl;
        }
        catch (IOException iOException) {
            throw new InvalidArgumentException(iOException.getMessage());
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProviderImpl != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl sipProviderImpl = new SipProviderImpl(this.eventScanner);
        sipProviderImpl.setSipStack(this);
        sipProviderImpl.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProviderImpl = sipProviderImpl;
        this.sipProviders.add(sipProviderImpl);
        return sipProviderImpl;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(listeningPointImpl.messageProcessor);
        String string = listeningPointImpl.getKey();
        this.listeningPoints.remove(string);
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.listeningPoint.messageProcessor.inUse()) {
            throw new ObjectInUseException("Provider in use");
        }
        sipProviderImpl.sipListener = null;
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    public ListeningPointImpl getListeningPoint(int n, String string) {
        String string2 = ListeningPointImpl.makeKey(this.stackAddress, n, string);
        return (ListeningPointImpl)this.listeningPoints.get(string2);
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public boolean isRetransmissionFilterActive() {
        return this.retransmissionFilter;
    }

    public Router getRouter() {
        return super.getRouter();
    }

    public Iterator getSipProviders() {
        return this.sipProviders.iterator();
    }

    public String getStackName() {
        return this.stackName;
    }

    protected String getDefaultTransport() {
        if (this.isTransportEnabled("udp")) {
            return "udp";
        }
        if (this.isTransportEnabled("tcp")) {
            return "tcp";
        }
        if (this.isTransportEnabled("tls")) {
            return "tls";
        }
        return null;
    }

    public void finalize() {
        this.stopStack();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

