/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.TooManyHopsException;

public class MaxForwards
extends SIPHeader
implements MaxForwardsHeader {
    protected int maxForwards;

    public MaxForwards() {
        super("Max-Forwards");
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(int n) throws InvalidArgumentException {
        if (n < 0 || n > 255) {
            throw new InvalidArgumentException("bad max forwards value " + n);
        }
        this.maxForwards = n;
    }

    public String encodeBody() {
        return new Integer(this.maxForwards).toString();
    }

    public boolean hasReachedZero() {
        return this.maxForwards == 0;
    }

    public void decrementMaxForwards() throws TooManyHopsException {
        if (this.maxForwards > 0) {
            --this.maxForwards;
        } else {
            throw new TooManyHopsException("has already reached 0!");
        }
    }
}

