/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.RetryAfterHeader;

public class RetryAfter
extends ParametersHeader
implements RetryAfterHeader {
    public static final String DURATION = "duration";
    protected Integer retryAfter;
    protected String comment;

    public RetryAfter() {
        super("Retry-After");
    }

    public String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.retryAfter != null) {
            stringBuffer.append(this.retryAfter);
        }
        if (this.comment != null) {
            stringBuffer.append(" (" + this.comment + ")");
        }
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";" + this.parameters.encode());
        }
        return stringBuffer.toString();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void removeDuration() {
        super.removeParameter(DURATION);
    }

    public void setRetryAfter(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("invalid parameter " + n);
        }
        this.retryAfter = new Integer(n);
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("the comment parameter is null");
        }
        this.comment = string;
    }

    public void setDuration(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("the duration parameter is <0");
        }
        super.setParameter(DURATION, new Integer(n));
    }

    public int getDuration() {
        int n = super.getParameterAsInt(DURATION);
        return n == -1 ? 0 : n;
    }
}

