/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.GenericObject;
import gov.nist.javax.sip.header.ExtensionHeaderList;
import gov.nist.javax.sip.header.Indentation;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPObject;
import gov.nist.javax.sip.header.SIPObjectList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SIPHeaderList
extends SIPHeader
implements List {
    protected static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";
    protected static final String SIP_PACKAGE = "gov.nist.javax.sip";
    protected SIPObjectList hlist;

    public SIPHeaderList(SIPObjectList sIPObjectList, String string) {
        super(string);
        this.hlist = sIPObjectList;
    }

    public SIPHeaderList(String string) {
        super(string);
        this.hlist = new SIPObjectList(null);
    }

    public SIPHeaderList(Class clazz, String string) {
        super(string);
        this.hlist = new SIPObjectList(string, clazz);
    }

    public SIPHeaderList(String string, String string2) {
        super(string2);
        this.hlist = new SIPObjectList(string2, string);
    }

    public boolean add(Object object) {
        return this.hlist.add(object);
    }

    public void addFirst(Object object) {
        this.hlist.addFirst(object);
    }

    public void add(SIPHeader sIPHeader, boolean bl) {
        if (bl) {
            this.addFirst(sIPHeader);
        } else {
            this.add(sIPHeader);
        }
    }

    public void concatenate(SIPHeaderList sIPHeaderList, boolean bl) throws IllegalArgumentException {
        if (!this.hlist.getMyClass().equals(sIPHeaderList.hlist.getMyClass())) {
            throw new IllegalArgumentException("SIPHeaderList concatenation " + this.hlist.getMyClass().getName() + "/" + sIPHeaderList.hlist.getMyClass().getName());
        }
        this.hlist.concatenate(sIPHeaderList.hlist, bl);
    }

    public void concatenate(SIPHeaderList sIPHeaderList) throws IllegalArgumentException {
        this.concatenate(sIPHeaderList, false);
    }

    public String encode() {
        if (this.hlist.isEmpty()) {
            return this.headerName + ":" + "\r\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization") || this instanceof ExtensionHeaderList) {
            ListIterator listIterator = this.hlist.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)listIterator.next();
                stringBuffer.append(sIPHeader.encode());
            }
            return stringBuffer.toString();
        }
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public LinkedList getHeadersAsEncodedStrings() {
        LinkedList<String> linkedList = new LinkedList<String>();
        ListIterator listIterator = this.hlist.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            linkedList.add(sIPHeader.encode());
        }
        return linkedList;
    }

    public SIPObject first() {
        return (SIPObject)this.hlist.first();
    }

    public SIPHeader getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.getFirst();
    }

    public SIPHeader getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.getLast();
    }

    public Class getMyClass() {
        return this.hlist.getMyClass();
    }

    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    public ListIterator listIterator() {
        return this.hlist.listIterator(0);
    }

    public SIPObjectList getHeaderList() {
        return this.hlist;
    }

    public ListIterator listIterator(int n) {
        return this.hlist.listIterator(n);
    }

    public SIPObject next() {
        return (SIPObject)this.hlist.next();
    }

    public SIPObject next(ListIterator listIterator) {
        return (SIPObject)this.hlist.next(listIterator);
    }

    public void removeAll(Class clazz) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object = (SIPHeader)this.hlist.first();
        while (object != null) {
            if (object.getClass().equals(clazz)) {
                linkedList.add(object);
            }
            object = (SIPHeader)this.hlist.next();
        }
        object = linkedList.listIterator();
        while (object.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)object.next();
            this.hlist.remove(sIPHeader);
        }
    }

    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.removeFirst();
        }
    }

    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.removeLast();
        }
    }

    public boolean remove(SIPHeader sIPHeader) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(sIPHeader);
    }

    protected void setMyClass(Class clazz) {
        this.hlist.setMyClass(clazz);
    }

    public String debugDump(int n) {
        this.stringRepresentation = "";
        String string = new Indentation(n).getIndentation();
        String string2 = this.getClass().getName();
        this.sprint(string + string2);
        this.sprint(string + "{");
        this.sprint(string + this.hlist.debugDump(n));
        this.sprint(string + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public Object[] toArray() {
        SIPHeader[] sIPHeaderArray = new SIPHeader[this.hlist.size()];
        return this.hlist.toArray(sIPHeaderArray);
    }

    public int indexOf(GenericObject genericObject) {
        return this.hlist.indexOf(genericObject);
    }

    public void add(int n, SIPHeader sIPHeader) throws IndexOutOfBoundsException {
        this.hlist.add(n, sIPHeader);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SIPHeaderList sIPHeaderList = (SIPHeaderList)object;
        if (this.hlist == sIPHeaderList.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        return this.hlist.equals(sIPHeaderList.hlist);
    }

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SIPHeaderList sIPHeaderList = (SIPHeaderList)object;
        if (this.hlist == sIPHeaderList.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        return this.hlist.match(sIPHeaderList.hlist);
    }

    public void merge(Object object) {
        if (object == null) {
            return;
        }
        if (!object.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + this.getClass());
        }
        SIPHeaderList sIPHeaderList = (SIPHeaderList)object;
        this.hlist.mergeObjects(sIPHeaderList.hlist);
    }

    public Object clone() {
        SIPHeaderList sIPHeaderList = (SIPHeaderList)super.clone();
        if (this.hlist != null) {
            sIPHeaderList.hlist = (SIPObjectList)this.hlist.clone();
        }
        return sIPHeaderList;
    }

    public int size() {
        return this.hlist.size();
    }

    public boolean isHeaderList() {
        return true;
    }

    protected String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.listIterator();
        while (true) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            stringBuffer.append(sIPHeader.encodeBody());
            if (!listIterator.hasNext()) break;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void add(int n, Object object) {
        this.hlist.add(n, object);
    }

    public boolean addAll(Collection collection) {
        return this.hlist.add(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.hlist.addAll(n, collection);
    }

    public void clear() {
        this.hlist.clear();
    }

    public boolean contains(Object object) {
        return this.hlist.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.hlist.containsAll(collection);
    }

    public Object get(int n) {
        return this.hlist.get(n);
    }

    public int indexOf(Object object) {
        return this.hlist.indexOf(object);
    }

    public Iterator iterator() {
        return this.hlist.listIterator();
    }

    public int lastIndexOf(Object object) {
        if (this.getMyClass() != null && !object.getClass().equals(this.getMyClass())) {
            return -1;
        }
        return this.hlist.lastIndexOf(object);
    }

    public boolean remove(Object object) {
        if (this.getMyClass() != null && !object.getClass().equals(this.getMyClass())) {
            return false;
        }
        return this.hlist.remove(object);
    }

    public Object remove(int n) {
        return this.hlist.remove(n);
    }

    public boolean removeAll(Collection collection) {
        return this.hlist.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.hlist.retainAll(collection);
    }

    public Object set(int n, Object object) {
        if (this.getMyClass() != null && !object.getClass().equals(this.getMyClass())) {
            throw new IllegalArgumentException("bad class expecting " + this.getMyClass());
        }
        return this.hlist.set(n, object);
    }

    public List subList(int n, int n2) {
        return this.hlist.subList(n, n2);
    }

    public Object[] toArray(Object[] objectArray) {
        return this.hlist.toArray();
    }
}

