/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.Protocol;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ViaHeader;

public class Via
extends ParametersHeader
implements ViaHeader {
    public static final String BRANCH = "branch";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    public static final String RPORT = "rport";
    protected Protocol sentProtocol = new Protocol();
    protected HostPort sentBy;
    protected String comment;

    public Via() {
        super("Via");
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Via via = (Via)object;
        if (!this.sentProtocol.equals(via.sentProtocol)) {
            return false;
        }
        return this.sentBy.equals(via.sentBy);
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public NameValueList getViaParms() {
        return this.parameters;
    }

    public String getComment() {
        return this.comment;
    }

    public Host getMaddr() {
        return (Host)this.parameters.getValue(MADDR);
    }

    public boolean hasPort() {
        return this.getSentBy().hasPort();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removePort() {
        this.sentBy.removePort();
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String string) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(string);
    }

    public void setHost(Host host) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setHost(host);
    }

    public void setSentProtocol(Protocol protocol) {
        this.sentProtocol = protocol;
    }

    public void setSentBy(HostPort hostPort) {
        this.sentBy = hostPort;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    protected String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sentProtocol.encode()).append(" ").append(this.sentBy.encode());
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";").append(this.parameters.encode());
        }
        if (this.comment != null) {
            stringBuffer.append(" ").append("(").append(this.comment).append(")");
        }
        return stringBuffer.toString();
    }

    public void setHost(String string) throws ParseException {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        try {
            Host host = new Host(string);
            this.sentBy.setHost(host);
        }
        catch (Exception exception) {
            throw new NullPointerException(" host parameter is null");
        }
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public void setPort(int n) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setPort(n);
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public int getrport() {
        String string = this.getParameter(RPORT);
        if (string != null) {
            return new Integer(string);
        }
        return -1;
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }

    public void setTransport(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setTransport(), the transport parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(string);
    }

    public String getProtocol() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolName();
    }

    public void setProtocol(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setProtocol(), the protocol parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolName(string);
    }

    public int getTTL() {
        int n = this.getParameterAsInt(TTL);
        return n;
    }

    public void setTTL(int n) throws InvalidArgumentException {
        if (n < 0 && n != -1) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Via, setTTL(), the ttl parameter is < 0");
        }
        this.setParameter(new NameValue(TTL, new Integer(n)));
    }

    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    public void setMAddr(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setMAddr(), the mAddr parameter is null.");
        }
        Host host = new Host();
        host.setAddress(string);
        NameValue nameValue = new NameValue(MADDR, host);
        this.setParameter(nameValue);
    }

    public String getReceived() {
        return this.getParameter(RECEIVED);
    }

    public void setReceived(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setReceived(), the received parameter is null.");
        }
        this.setParameter(RECEIVED, string);
    }

    public String getBranch() {
        return this.getParameter(BRANCH);
    }

    public void setBranch(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setBranch(), the branch parameter is null.");
        }
        this.setParameter(BRANCH, string);
    }

    public Object clone() {
        Via via = (Via)super.clone();
        if (this.sentProtocol != null) {
            via.sentProtocol = (Protocol)this.sentProtocol.clone();
        }
        if (this.sentBy != null) {
            via.sentBy = (HostPort)this.sentBy.clone();
        }
        return via;
    }
}

