/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class MessageObject
extends GenericObject {
    protected static final String MESSAGE_PACKAGE = "gov.nist.javax.sip.message";
    protected static final String SIP_PACKAGE = "gov.nist.javax.sip";
    protected static final String PARSER_PACKAGE = "gov.nist.javax.sip.parser";
    protected static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";

    public abstract String encode();

    public void dbgPrint() {
        super.dbgPrint();
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> clazz = this.getClass();
        this.sprint(clazz.getName());
        this.sprint("{");
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (n == 2) continue;
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            if (string.compareTo("stringRepresentation") == 0 || string.compareTo("indentation") == 0) continue;
            this.sprint(string + ":");
            try {
                if (clazz2.isPrimitive()) {
                    String string2 = clazz2.toString();
                    this.sprint(string2 + ":");
                    if (string2.compareTo("int") == 0) {
                        int n2 = field.getInt(this);
                        this.sprint(n2);
                        continue;
                    }
                    if (string2.compareTo("short") == 0) {
                        short s = field.getShort(this);
                        this.sprint(s);
                        continue;
                    }
                    if (string2.compareTo("char") == 0) {
                        char c = field.getChar(this);
                        this.sprint(c);
                        continue;
                    }
                    if (string2.compareTo("long") == 0) {
                        long l = field.getLong(this);
                        this.sprint(l);
                        continue;
                    }
                    if (string2.compareTo("boolean") == 0) {
                        boolean bl = field.getBoolean(this);
                        this.sprint(bl);
                        continue;
                    }
                    if (string2.compareTo("double") == 0) {
                        double d = field.getDouble(this);
                        this.sprint(d);
                        continue;
                    }
                    if (string2.compareTo("float") != 0) continue;
                    float f = field.getFloat(this);
                    this.sprint(f);
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObject").isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObject)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObjectList").isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObjectList)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (field.get(this) != null) {
                    this.sprint(field.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(clazz2.getName() + ":");
                }
                this.sprint("{");
                if (field.get(this) != null) {
                    this.sprint(field.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public void merge(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad override object");
        }
        if (object == null) {
            return;
        }
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (Modifier.isPrivate(n) || Modifier.isStatic(n) || Modifier.isInterface(n)) continue;
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            String string2 = clazz2.toString();
            try {
                Cloneable cloneable;
                if (clazz2.isPrimitive()) {
                    if (string2.compareTo("int") == 0) {
                        int n2 = field.getInt(object);
                        field.setInt(this, n2);
                        continue;
                    }
                    if (string2.compareTo("short") == 0) {
                        short s = field.getShort(object);
                        field.setShort(this, s);
                        continue;
                    }
                    if (string2.compareTo("char") == 0) {
                        char c = field.getChar(object);
                        field.setChar(this, c);
                        continue;
                    }
                    if (string2.compareTo("long") == 0) {
                        long l = field.getLong(object);
                        field.setLong(this, l);
                        continue;
                    }
                    if (string2.compareTo("boolean") == 0) {
                        boolean bl = field.getBoolean(object);
                        field.setBoolean(this, bl);
                        continue;
                    }
                    if (string2.compareTo("double") == 0) {
                        double d = field.getDouble(object);
                        field.setDouble(this, d);
                        continue;
                    }
                    if (string2.compareTo("float") != 0) continue;
                    float f = field.getFloat(object);
                    field.setFloat(this, f);
                    continue;
                }
                Object object2 = field.get(this);
                Object object3 = field.get(object);
                if (object3 == null) continue;
                if (object2 == null) {
                    field.set(this, object3);
                    continue;
                }
                if (object2 instanceof GenericObject) {
                    cloneable = (GenericObject)object2;
                    ((GenericObject)cloneable).merge(object3);
                    continue;
                }
                if (object2 instanceof GenericObjectList) {
                    cloneable = (GenericObjectList)object2;
                    ((GenericObjectList)cloneable).mergeObjects((GenericObjectList)object3);
                    continue;
                }
                field.set(this, object3);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    protected MessageObject() {
    }

    public String dbgPrint(int n) {
        int n2 = this.indentation;
        this.indentation = n;
        String string = this.toString();
        this.indentation = n2;
        return string;
    }
}

