/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.message.Response;

public final class SIPResponse
extends SIPMessage
implements Response {
    protected StatusLine statusLine;

    public static String getReasonPhrase(int n) {
        String string = null;
        switch (n) {
            case 100: {
                string = "Trying";
                break;
            }
            case 180: {
                string = "Ringing";
                break;
            }
            case 181: {
                string = "Call is being forwarded";
                break;
            }
            case 182: {
                string = "Queued";
                break;
            }
            case 183: {
                string = "Session progress";
                break;
            }
            case 200: {
                string = "OK";
                break;
            }
            case 202: {
                string = "Accepted";
                break;
            }
            case 300: {
                string = "Multiple choices";
                break;
            }
            case 301: {
                string = "Moved permanently";
                break;
            }
            case 302: {
                string = "Moved Temporarily";
                break;
            }
            case 305: {
                string = "Use proxy";
                break;
            }
            case 380: {
                string = "Alternative service";
                break;
            }
            case 400: {
                string = "Bad request";
                break;
            }
            case 401: {
                string = "Unauthorized";
                break;
            }
            case 402: {
                string = "Payment required";
                break;
            }
            case 403: {
                string = "Forbidden";
                break;
            }
            case 404: {
                string = "Not found";
                break;
            }
            case 405: {
                string = "Method not allowed";
                break;
            }
            case 406: {
                string = "Not acceptable";
                break;
            }
            case 407: {
                string = "Proxy Authentication required";
                break;
            }
            case 408: {
                string = "Request timeout";
                break;
            }
            case 410: {
                string = "Gone";
                break;
            }
            case 480: {
                string = "Temporarily Unavailable";
                break;
            }
            case 413: {
                string = "Request entity too large";
                break;
            }
            case 414: {
                string = "Request-URI too large";
                break;
            }
            case 415: {
                string = "Unsupported media type";
                break;
            }
            case 416: {
                string = "Unsupported URI Scheme";
                break;
            }
            case 420: {
                string = "Bad extension";
                break;
            }
            case 421: {
                string = "Etension Required";
                break;
            }
            case 423: {
                string = "Interval too brief";
                break;
            }
            case 481: {
                string = "Call leg/Transaction does not exist";
                break;
            }
            case 482: {
                string = "Loop detected";
                break;
            }
            case 483: {
                string = "Too many hops";
                break;
            }
            case 484: {
                string = "Address incomplete";
                break;
            }
            case 485: {
                string = "Ambiguous";
                break;
            }
            case 486: {
                string = "Busy here";
                break;
            }
            case 487: {
                string = "Request Terminated";
                break;
            }
            case 488: {
                string = "Not Accpetable here";
                break;
            }
            case 489: {
                string = "Bad Event";
                break;
            }
            case 491: {
                string = "Request Pending";
                break;
            }
            case 500: {
                string = "Server Internal Error";
                break;
            }
            case 493: {
                string = "Undecipherable";
                break;
            }
            case 501: {
                string = "Not implemented";
                break;
            }
            case 502: {
                string = "Bad gateway";
                break;
            }
            case 503: {
                string = "Service unavailable";
                break;
            }
            case 504: {
                string = "Gateway timeout";
                break;
            }
            case 505: {
                string = "SIP version not supported";
                break;
            }
            case 513: {
                string = "Message Too Large";
                break;
            }
            case 600: {
                string = "Busy everywhere";
                break;
            }
            case 603: {
                string = "Decline";
                break;
            }
            case 604: {
                string = "Does not exist anywhere";
                break;
            }
            case 606: {
                string = "Session Not acceptable";
                break;
            }
            default: {
                string = "Unkown Reason";
            }
        }
        return string;
    }

    public void setStatusCode(int n) throws ParseException {
        if (n < 100 || n > 800) {
            throw new ParseException("bad status code", 0);
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setStatusCode(n);
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public void setReasonPhrase(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Bad reason phrase");
        }
        if (this.statusLine == null) {
            this.statusLine = new StatusLine();
        }
        this.statusLine.setReasonPhrase(string);
    }

    public String getReasonPhrase() {
        if (this.statusLine == null || this.statusLine.getReasonPhrase() == null) {
            return "";
        }
        return this.statusLine.getReasonPhrase();
    }

    public static boolean isFinalResponse(int n) {
        return n >= 200 && n < 700;
    }

    public boolean isFinalResponse() {
        return SIPResponse.isFinalResponse(this.statusLine.getStatusCode());
    }

    public void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public String debugDump() {
        String string = super.debugDump();
        this.stringRepresentation = "";
        this.sprint("gov.nist.javax.sip.message.SIPResponse");
        this.sprint("{");
        if (this.statusLine != null) {
            this.sprint(this.statusLine.debugDump());
        }
        this.sprint(string);
        this.sprint("}");
        return this.stringRepresentation;
    }

    protected void checkHeaders() throws ParseException {
        if (this.getCSeq() == null) {
            throw new ParseException("CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException("To", 0);
        }
        if (this.getFrom() == null) {
            throw new ParseException("From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException("Via", 0);
        }
    }

    public String encode() {
        String string = this.statusLine != null ? this.statusLine.encode() + super.encode() : super.encode();
        return string;
    }

    public String encodeMessage() {
        String string = this.statusLine != null ? this.statusLine.encode() + super.encodeSIPHeaders() : super.encodeSIPHeaders();
        return string;
    }

    public LinkedList getMessageAsEncodedStrings() {
        LinkedList linkedList = super.getMessageAsEncodedStrings();
        if (this.statusLine != null) {
            linkedList.addFirst(this.statusLine.encode());
        }
        return linkedList;
    }

    public Object clone() {
        SIPResponse sIPResponse = (SIPResponse)super.clone();
        if (this.statusLine != null) {
            sIPResponse.statusLine = (StatusLine)this.statusLine.clone();
        }
        return sIPResponse;
    }

    public void replace(String string, GenericObject genericObject, boolean bl) {
        if (string == null || genericObject == null) {
            throw new IllegalArgumentException("null args!");
        }
        if (genericObject instanceof SIPHeader) {
            throw new IllegalArgumentException("Bad replacement class " + genericObject.getClass().getName());
        }
        if (this.statusLine != null) {
            this.statusLine.replace(string, genericObject, bl);
        }
        super.replace(string, genericObject, bl);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SIPResponse sIPResponse = (SIPResponse)object;
        return this.statusLine.equals(sIPResponse.statusLine) && super.equals(object);
    }

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        if (object == this) {
            return true;
        }
        SIPResponse sIPResponse = (SIPResponse)object;
        StatusLine statusLine = sIPResponse.statusLine;
        if (this.statusLine == null && statusLine != null) {
            return false;
        }
        if (this.statusLine == statusLine) {
            return super.match(object);
        }
        return this.statusLine.match(sIPResponse.statusLine) && super.match(object);
    }

    public byte[] encodeAsBytes() {
        byte[] byArray = null;
        if (this.statusLine != null) {
            try {
                byArray = this.statusLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                InternalErrorHandler.handleException(unsupportedEncodingException);
            }
        }
        byte[] byArray2 = super.encodeAsBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n = 0;
        if (byArray != null) {
            for (n = 0; n < byArray.length; ++n) {
                byArray3[n] = byArray[n];
            }
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray3[n] = byArray2[n2];
            ++n2;
            ++n;
        }
        return byArray3;
    }

    public String getDialogId(boolean bl) {
        CallID callID = (CallID)this.getCallId();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        StringBuffer stringBuffer = new StringBuffer(callID.getCallId());
        if (!bl) {
            stringBuffer.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
            stringBuffer.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(to.getTag());
            }
        } else {
            stringBuffer.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(to.getTag());
            }
            stringBuffer.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
        }
        return stringBuffer.toString().toLowerCase();
    }

    public String getDialogId(boolean bl, String string) {
        CallID callID = (CallID)this.getCallId();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        StringBuffer stringBuffer = new StringBuffer(callID.getCallId());
        if (!bl) {
            stringBuffer.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
            stringBuffer.append(":").append(to.getUserAtHostPort());
            if (string != null) {
                stringBuffer.append(":");
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(":").append(to.getUserAtHostPort());
            if (string != null) {
                stringBuffer.append(":");
                stringBuffer.append(string);
            }
            stringBuffer.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                stringBuffer.append(":");
                stringBuffer.append(from.getTag());
            }
        }
        return stringBuffer.toString().toLowerCase();
    }

    public SIPRequest createRequest(SipUri sipUri, Via via, CSeq cSeq) {
        SIPRequest sIPRequest = new SIPRequest();
        String string = cSeq.getMethod();
        sIPRequest.setMethod(string);
        sIPRequest.setRequestURI(sipUri);
        if ((string.equalsIgnoreCase("ACK") || string.equalsIgnoreCase("CANCEL")) && this.getTopmostVia().getBranch() != null) {
            try {
                via.setBranch(this.getTopmostVia().getBranch());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        sIPRequest.setHeader(via);
        sIPRequest.setHeader(cSeq);
        ListIterator listIterator = this.getHeaders();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            if (SIPMessage.isResponseHeader(sIPHeader) || sIPHeader instanceof ViaList || sIPHeader instanceof CSeq || sIPHeader instanceof ContentType || sIPHeader instanceof RecordRouteList) continue;
            if (sIPHeader instanceof To) {
                sIPHeader = (SIPHeader)sIPHeader.clone();
            } else if (sIPHeader instanceof From) {
                sIPHeader = (SIPHeader)sIPHeader.clone();
            }
            try {
                sIPRequest.attachHeader(sIPHeader, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
                sIPDuplicateHeaderException.printStackTrace();
            }
        }
        return sIPRequest;
    }

    public String getFirstLine() {
        if (this.statusLine == null) {
            return null;
        }
        return this.statusLine.encode();
    }

    public void setSIPVersion(String string) {
        this.statusLine.setSipVersion(string);
    }

    public String getSIPVersion() {
        return this.statusLine.getSipVersion();
    }

    public String toString() {
        if (this.statusLine == null) {
            return "";
        }
        return this.statusLine.encode() + super.encode();
    }
}

