/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import javax.sip.address.Hop;

public abstract class SIPTransactionStack
extends SIPMessageStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 32;
    private List clientTransactions;
    private List serverTransactions;
    protected Hashtable dialogTable;
    protected int transactionTableSize = -1;
    protected boolean retransmissionFilter;
    protected HashSet dialogCreatingMethods = new HashSet();
    private int activeClientTransactionCount;
    private int activeServerTransactionCount;
    protected Timer timer;
    protected Thread pendingRecordScanner;
    private HashSet pendingTransactions;
    private List pendingRecords;
    private Hashtable clientTransactionTable;
    private Hashtable serverTransactionTable;

    protected SIPTransactionStack() {
        this.dialogCreatingMethods.add("REFER");
        this.dialogCreatingMethods.add("INVITE");
        this.dialogCreatingMethods.add("SUBSCRIBE");
        this.clientTransactions = Collections.synchronizedList(new ArrayList());
        this.serverTransactions = Collections.synchronizedList(new ArrayList());
        this.dialogTable = new Hashtable();
        this.clientTransactionTable = new Hashtable();
        this.serverTransactionTable = new Hashtable();
        this.timer = new Timer();
        this.pendingRecordScanner = new Thread(new PendingRecordScanner(this));
        this.pendingRecordScanner.setDaemon(true);
        this.pendingTransactions = new HashSet();
        this.pendingRecords = Collections.synchronizedList(new ArrayList());
        this.pendingRecordScanner.setName("PendingRecordScanner");
        this.pendingRecordScanner.start();
    }

    protected void reInit() {
        super.reInit();
        this.clientTransactions = Collections.synchronizedList(new ArrayList());
        this.serverTransactions = Collections.synchronizedList(new ArrayList());
        this.pendingTransactions = new HashSet();
        this.pendingRecords = Collections.synchronizedList(new ArrayList());
        this.clientTransactionTable = new Hashtable();
        this.serverTransactionTable = new Hashtable();
        this.dialogTable = new Hashtable();
        this.timer = new Timer();
        this.pendingRecordScanner = new Thread(new PendingRecordScanner(this));
        this.pendingRecordScanner.setDaemon(true);
        this.pendingRecordScanner.setName("PendingRecordScanner");
        this.pendingRecordScanner.start();
    }

    public boolean isDialogCreated(String string) {
        return this.dialogCreatingMethods.contains(string.toUpperCase());
    }

    public void addExtensionMethod(String string) {
        if (string.equals("NOTIFY")) {
            if (LogWriter.needsLogging) {
                this.logWriter.logMessage("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.add(string.trim().toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDialog(SIPDialog sIPDialog) {
        String string = sIPDialog.getDialogId();
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            if (this.dialogTable.containsKey(string)) {
                return;
            }
        }
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("putDialog dialogId=" + string);
        }
        sIPDialog.setStack(this);
        if (LogWriter.needsLogging) {
            this.logWriter.logStackTrace();
        }
        hashtable = this.dialogTable;
        synchronized (hashtable) {
            this.dialogTable.put(string, sIPDialog);
        }
    }

    public SIPDialog createDialog(SIPTransaction sIPTransaction) {
        SIPDialog sIPDialog = new SIPDialog(sIPTransaction);
        return sIPDialog;
    }

    public Iterator getDialogs() {
        return this.dialogTable.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDialog(SIPDialog sIPDialog) {
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            Iterator iterator = this.dialogTable.values().iterator();
            while (iterator.hasNext()) {
                SIPDialog sIPDialog2 = (SIPDialog)iterator.next();
                if (sIPDialog2 != sIPDialog) continue;
                if (LogWriter.needsLogging) {
                    String string = sIPDialog.getDialogId();
                    this.logWriter.logMessage("Removing Dialog " + string);
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPDialog getDialog(String string) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Getting dialog for " + string);
        }
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            return (SIPDialog)this.dialogTable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest sIPRequest) {
        List list = this.clientTransactions;
        synchronized (list) {
            Iterator iterator = this.clientTransactions.iterator();
            String string = sIPRequest.getTo().getTag();
            if (string == null) {
                return null;
            }
            Event event = (Event)sIPRequest.getHeader("Event");
            if (event == null) {
                return null;
            }
            while (iterator.hasNext()) {
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)iterator.next();
                String string2 = sIPClientTransaction.from.getTag();
                Event event2 = sIPClientTransaction.event;
                if (event2 == null || !sIPClientTransaction.method.equals("SUBSCRIBE") || !string2.equalsIgnoreCase(string) || event2 == null || !event.match(event2) || !sIPRequest.getCallId().getCallId().equalsIgnoreCase(sIPClientTransaction.callId.getCallId())) continue;
                return sIPClientTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPTransaction findTransaction(SIPMessage sIPMessage, boolean bl) {
        Object object;
        Object object2;
        SIPTransaction sIPTransaction = null;
        if (bl) {
            Object object3;
            Object object4;
            Via via = sIPMessage.getTopmostVia();
            if (via.getBranch() != null) {
                object4 = sIPMessage.getTransactionId();
                object3 = this.serverTransactionTable;
                synchronized (object3) {
                    sIPTransaction = (SIPTransaction)this.serverTransactionTable.get(object4);
                    if (LogWriter.needsLogging) {
                        this.logMessage("looking for key " + (String)object4);
                    }
                    if (sIPTransaction != null && sIPTransaction.isMessagePartOfTransaction(sIPMessage)) {
                        return sIPTransaction;
                    }
                }
            }
            object4 = this.serverTransactions;
            synchronized (object4) {
                object3 = this.serverTransactions.iterator();
                while (object3.hasNext()) {
                    SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)object3.next();
                    if (!sIPServerTransaction.isMessagePartOfTransaction(sIPMessage)) continue;
                    return sIPServerTransaction;
                }
            }
        }
        Via via = sIPMessage.getTopmostVia();
        if (via.getBranch() != null) {
            object2 = sIPMessage.getTransactionId();
            object = this.clientTransactionTable;
            synchronized (object) {
                sIPTransaction = (SIPTransaction)this.clientTransactionTable.get(object2);
                if (sIPTransaction != null && sIPTransaction.isMessagePartOfTransaction(sIPMessage)) {
                    return sIPTransaction;
                }
            }
        }
        object2 = this.clientTransactions;
        synchronized (object2) {
            object = this.clientTransactions.iterator();
            while (object.hasNext()) {
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)object.next();
                if (!sIPClientTransaction.isMessagePartOfTransaction(sIPMessage)) continue;
                return sIPClientTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPTransaction findCancelTransaction(SIPRequest sIPRequest, boolean bl) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("findCancelTransaction request= \n" + sIPRequest + "\nfindCancelRequest isServer=" + bl);
        }
        if (bl) {
            List list = this.serverTransactions;
            synchronized (list) {
                Iterator iterator = this.serverTransactions.iterator();
                while (iterator.hasNext()) {
                    SIPTransaction sIPTransaction = (SIPTransaction)iterator.next();
                    SIPRequest sIPRequest2 = (SIPRequest)sIPTransaction.getRequest();
                    SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)sIPTransaction;
                    if (!sIPServerTransaction.doesCancelMatchTransaction(sIPRequest)) continue;
                    return sIPServerTransaction;
                }
            }
        }
        List list = this.clientTransactions;
        synchronized (list) {
            Iterator iterator = this.clientTransactions.iterator();
            while (iterator.hasNext()) {
                SIPTransaction sIPTransaction = (SIPTransaction)iterator.next();
                SIPRequest sIPRequest3 = (SIPRequest)sIPTransaction.getRequest();
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)sIPTransaction;
                if (!sIPClientTransaction.doesCancelMatchTransaction(sIPRequest)) continue;
                return sIPClientTransaction;
            }
        }
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory stackMessageFactory) {
        this();
        this.sipMessageFactory = stackMessageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPServerTransaction findPendingTransaction(SIPRequest sIPRequest) {
        SIPServerTransaction sIPServerTransaction;
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            Iterator iterator = this.pendingTransactions.iterator();
            sIPServerTransaction = null;
            while (iterator.hasNext() && sIPServerTransaction == null) {
                SIPServerTransaction sIPServerTransaction2 = (SIPServerTransaction)iterator.next();
                if (!sIPServerTransaction2.isMessagePartOfTransaction(sIPRequest)) continue;
                sIPServerTransaction = sIPServerTransaction2;
            }
        }
        return sIPServerTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingTransaction(SIPServerTransaction sIPServerTransaction) {
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            this.pendingTransactions.remove(sIPServerTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerRequestInterface newSIPServerRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        String string = sIPRequest.getTransactionId();
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)this.serverTransactionTable.get(string);
        if (sIPServerTransaction == null || !sIPServerTransaction.isMessagePartOfTransaction(sIPRequest)) {
            List list = this.serverTransactions;
            synchronized (list) {
                Iterator iterator = this.serverTransactions.iterator();
                sIPServerTransaction = null;
                while (iterator.hasNext() && sIPServerTransaction == null) {
                    SIPServerTransaction sIPServerTransaction2 = (SIPServerTransaction)iterator.next();
                    if (!sIPServerTransaction2.isMessagePartOfTransaction(sIPRequest)) continue;
                    sIPServerTransaction = sIPServerTransaction2;
                }
                if (sIPServerTransaction == null) {
                    sIPServerTransaction = this.findPendingTransaction(sIPRequest);
                    if (sIPServerTransaction != null) {
                        return sIPServerTransaction;
                    }
                    sIPServerTransaction = this.createServerTransaction(messageChannel);
                    sIPServerTransaction.setOriginalRequest(sIPRequest);
                    if (!this.isDialogCreated(sIPRequest.getMethod())) {
                        String string2 = sIPRequest.getDialogId(true);
                        SIPDialog sIPDialog = this.getDialog(string2);
                        if (sIPDialog != null && (sIPRequest.getMethod().equals("ACK") || sIPRequest.getCSeq().getSequenceNumber() > sIPDialog.getRemoteSequenceNumber())) {
                            if (LogWriter.needsLogging) {
                                this.logWriter.logMessage("adding server transaction " + sIPServerTransaction);
                            }
                            this.serverTransactions.add(0, sIPServerTransaction);
                            this.addTransactionHash(sIPServerTransaction);
                            sIPServerTransaction.startTransactionTimer();
                            sIPServerTransaction.isMapped = true;
                        }
                    } else {
                        String string3 = sIPRequest.getDialogId(true);
                        SIPDialog sIPDialog = this.getDialog(string3);
                        if (sIPDialog != null && sIPRequest.getCSeq().getSequenceNumber() > sIPDialog.getRemoteSequenceNumber()) {
                            sIPServerTransaction.map();
                            if (LogWriter.needsLogging) {
                                this.logWriter.logMessage("adding server transaction " + sIPServerTransaction);
                            }
                            this.serverTransactions.add(0, sIPServerTransaction);
                            this.addTransactionHash(sIPServerTransaction);
                            sIPServerTransaction.startTransactionTimer();
                            sIPServerTransaction.toListener = true;
                        }
                    }
                }
            }
        }
        sIPServerTransaction.setRequestInterface(super.newSIPServerRequest(sIPRequest, sIPServerTransaction));
        return sIPServerTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerResponseInterface newSIPServerResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        String string = sIPResponse.getTransactionId();
        SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.clientTransactionTable.get(string);
        if (sIPClientTransaction == null || !sIPClientTransaction.isMessagePartOfTransaction(sIPResponse)) {
            List list = this.clientTransactions;
            synchronized (list) {
                Iterator iterator = this.clientTransactions.iterator();
                sIPClientTransaction = null;
                while (iterator.hasNext() && sIPClientTransaction == null) {
                    SIPClientTransaction sIPClientTransaction2 = (SIPClientTransaction)iterator.next();
                    if (!sIPClientTransaction2.isMessagePartOfTransaction(sIPResponse)) continue;
                    sIPClientTransaction = sIPClientTransaction2;
                }
            }
            if (sIPClientTransaction == null) {
                return super.newSIPServerResponse(sIPResponse, messageChannel);
            }
        }
        sIPClientTransaction.setResponseInterface(super.newSIPServerResponse(sIPResponse, sIPClientTransaction));
        return sIPClientTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(int n, Hop hop) throws UnknownHostException {
        List list = this.clientTransactions;
        synchronized (list) {
            MessageChannel messageChannel = super.createMessageChannel(n, hop);
            if (messageChannel == null) {
                return null;
            }
            SIPClientTransaction sIPClientTransaction = this.createClientTransaction(messageChannel);
            this.clientTransactions.add(0, sIPClientTransaction);
            sIPClientTransaction.setViaPort(hop.getPort());
            sIPClientTransaction.setViaHost(hop.getHost());
            ((SIPTransaction)sIPClientTransaction).startTransactionTimer();
            return sIPClientTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(MessageChannel messageChannel) {
        List list = this.clientTransactions;
        synchronized (list) {
            SIPClientTransaction sIPClientTransaction = this.createClientTransaction(messageChannel);
            this.clientTransactions.add(0, sIPClientTransaction);
            sIPClientTransaction.setViaPort(messageChannel.getViaPort());
            sIPClientTransaction.setViaHost(messageChannel.getHost());
            ((SIPTransaction)sIPClientTransaction).startTransactionTimer();
            return sIPClientTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(SIPTransaction sIPTransaction) {
        List list = this.clientTransactions;
        synchronized (list) {
            SIPClientTransaction sIPClientTransaction = this.createClientTransaction(sIPTransaction.getMessageChannel());
            this.clientTransactions.add(0, sIPClientTransaction);
            sIPClientTransaction.setViaPort(sIPTransaction.getViaPort());
            sIPClientTransaction.setViaHost(sIPTransaction.getViaHost());
            ((SIPTransaction)sIPClientTransaction).startTransactionTimer();
            return sIPClientTransaction;
        }
    }

    public SIPClientTransaction createClientTransaction(MessageChannel messageChannel) {
        return new SIPClientTransaction(this, messageChannel);
    }

    public SIPServerTransaction createServerTransaction(MessageChannel messageChannel) {
        return new SIPServerTransaction(this, messageChannel);
    }

    public MessageChannel createRawMessageChannel(int n, Hop hop) throws UnknownHostException {
        return super.createMessageChannel(n, hop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(SIPClientTransaction sIPClientTransaction) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("added transaction " + sIPClientTransaction);
        }
        List list = this.clientTransactions;
        synchronized (list) {
            this.clientTransactions.add(0, sIPClientTransaction);
        }
        this.addTransactionHash(sIPClientTransaction);
        sIPClientTransaction.startTransactionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(SIPTransaction sIPTransaction) {
        if (sIPTransaction instanceof SIPServerTransaction) {
            Object object = this.serverTransactions;
            synchronized (object) {
                this.serverTransactions.remove(sIPTransaction);
            }
            object = this.serverTransactionTable;
            synchronized (object) {
                String string = sIPTransaction.getTransactionId();
                this.serverTransactionTable.remove(string);
            }
        }
        Object object = this.clientTransactions;
        synchronized (object) {
            this.clientTransactions.remove(sIPTransaction);
        }
        object = this.clientTransactionTable;
        synchronized (object) {
            String string = sIPTransaction.getTransactionId();
            this.clientTransactionTable.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(SIPServerTransaction sIPServerTransaction) throws IOException {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("added transaction " + sIPServerTransaction);
        }
        List list = this.serverTransactions;
        synchronized (list) {
            this.serverTransactions.add(0, sIPServerTransaction);
            sIPServerTransaction.map();
        }
        this.addTransactionHash(sIPServerTransaction);
        sIPServerTransaction.startTransactionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransactionHash(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        Via via = sIPRequest.getTopmostVia();
        if (sIPTransaction instanceof SIPClientTransaction) {
            Hashtable hashtable = this.clientTransactionTable;
            synchronized (hashtable) {
                String string = sIPRequest.getTransactionId();
                this.clientTransactionTable.put(string, sIPTransaction);
            }
        }
        Hashtable hashtable = this.serverTransactionTable;
        synchronized (hashtable) {
            String string = sIPRequest.getTransactionId();
            this.serverTransactionTable.put(string, sIPTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransactionHash(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        if (sIPRequest == null) {
            return;
        }
        if (sIPTransaction instanceof SIPClientTransaction) {
            Hashtable hashtable = this.clientTransactionTable;
            synchronized (hashtable) {
                String string = sIPTransaction.getTransactionId();
                this.clientTransactionTable.remove(string);
            }
        }
        if (sIPTransaction instanceof SIPServerTransaction) {
            Hashtable hashtable = this.serverTransactionTable;
            synchronized (hashtable) {
                String string = sIPTransaction.getTransactionId();
                this.serverTransactionTable.remove(string);
            }
        }
    }

    public boolean hasResources() {
        if (this.transactionTableSize == -1) {
            return true;
        }
        return this.serverTransactions.size() < this.transactionTableSize;
    }

    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent sIPTransactionErrorEvent) {
        SIPTransaction sIPTransaction = (SIPTransaction)sIPTransactionErrorEvent.getSource();
        if (sIPTransactionErrorEvent.getErrorID() == 2) {
            sIPTransaction.setState(SIPTransaction.TERMINATED_STATE);
            if (sIPTransaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)sIPTransaction).collectionTime = 0;
            }
            sIPTransaction.disableTimeoutTimer();
            sIPTransaction.disableRetransmissionTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPending(PendingRecord pendingRecord) {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.add(pendingRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePending(PendingRecord pendingRecord) {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.remove(pendingRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPendingRecordScanner() {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.notify();
        }
    }

    public void stopStack() {
        this.notifyPendingRecordScanner();
        this.timer.cancel();
        this.pendingTransactions.clear();
        super.stopStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPendingTransaction(SIPServerTransaction sIPServerTransaction) {
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            this.pendingTransactions.add(sIPServerTransaction);
        }
    }

    static /* synthetic */ List access$000(SIPTransactionStack sIPTransactionStack) {
        return sIPTransactionStack.pendingRecords;
    }

    class PendingRecordScanner
    implements Runnable {
        SIPTransactionStack myStack;

        protected PendingRecordScanner(SIPTransactionStack sIPTransactionStack2) {
            this.myStack = sIPTransactionStack2;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

