/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class TLSMessageProcessor
extends MessageProcessor {
    protected Thread thread;
    protected int port;
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tlsMessageChannels;
    private SSLServerSocket sock;
    protected int useCount = 0;
    protected SIPMessageStack sipStack;

    protected TLSMessageProcessor(SIPMessageStack sIPMessageStack, int n) {
        this.sipStack = sIPMessageStack;
        this.port = n;
        this.tlsMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        this.thread = new Thread(this);
        this.thread.setName("TLSMessageProcessorThread");
        this.thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.port, 0, this.sipStack.savedStackInetAddress);
        this.isRunning = true;
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                Object object = this;
                synchronized (object) {
                    while (this.isRunning && this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                object = (SSLSocket)this.sock.accept();
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("Accepting new connection!");
                }
                TLSMessageChannel tLSMessageChannel = new TLSMessageChannel((SSLSocket)object, this.sipStack, this);
            }
            catch (SocketException socketException) {
                this.isRunning = false;
            }
            catch (IOException iOException) {
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logException(iOException);
            }
            catch (Exception exception) {
                InternalErrorHandler.handleException(exception);
            }
        }
    }

    public String getTransport() {
        return "tls";
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        this.isRunning = false;
        this.listeningPoint = null;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Collection collection = this.tlsMessageChannels.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TLSMessageChannel tLSMessageChannel = (TLSMessageChannel)iterator.next();
            tLSMessageChannel.close();
        }
        this.notify();
    }

    protected synchronized void remove(TLSMessageChannel tLSMessageChannel) {
        String string = tLSMessageChannel.getKey();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage(Thread.currentThread() + " removing " + string);
        }
        if (this.tlsMessageChannels.get(string) == tLSMessageChannel) {
            this.tlsMessageChannels.remove(string);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort hostPort) throws IOException {
        String string = MessageChannel.getKey(hostPort, "TLS");
        if (this.tlsMessageChannels.get(string) != null) {
            return (TLSMessageChannel)this.tlsMessageChannels.get(string);
        }
        TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(hostPort.getInetAddress(), hostPort.getPort(), this.sipStack, this);
        this.tlsMessageChannels.put(string, tLSMessageChannel);
        tLSMessageChannel.isCached = true;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("key " + string);
            this.sipStack.logWriter.logMessage("Creating " + tLSMessageChannel);
        }
        return tLSMessageChannel;
    }

    protected synchronized void cacheMessageChannel(TLSMessageChannel tLSMessageChannel) {
        String string = tLSMessageChannel.getKey();
        TLSMessageChannel tLSMessageChannel2 = (TLSMessageChannel)this.tlsMessageChannels.get(string);
        if (tLSMessageChannel2 != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Closing " + string);
            }
            tLSMessageChannel2.close();
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Caching " + string);
        }
        this.tlsMessageChannels.put(string, tLSMessageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress inetAddress, int n) throws IOException {
        try {
            String string = MessageChannel.getKey(inetAddress, n, "TLS");
            if (this.tlsMessageChannels.get(string) != null) {
                return (TLSMessageChannel)this.tlsMessageChannels.get(string);
            }
            TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(inetAddress, n, this.sipStack, this);
            this.tlsMessageChannels.put(string, tLSMessageChannel);
            tLSMessageChannel.isCached = true;
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("key " + string);
                this.sipStack.logMessage("Creating " + tLSMessageChannel);
            }
            return tLSMessageChannel;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public String getNAPTRService() {
        return "SIPS+D2T";
    }

    public String getSRVPrefix() {
        return "_sip._tls.";
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5061;
    }

    public boolean isSecure() {
        return true;
    }
}

