/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class UDPMessageProcessor
extends MessageProcessor {
    private int port;
    private int mappedPort;
    protected LinkedList messageQueue;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected static final int MAX_DATAGRAM_SIZE = 8192;
    protected SIPMessageStack sipStack;
    protected Thread thread;
    protected DatagramSocket sock;
    protected boolean isRunning;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$DatagramSocket;

    protected UDPMessageProcessor(SIPMessageStack sIPMessageStack, int n) throws IOException {
        this.sipStack = sIPMessageStack;
        this.messageQueue = new LinkedList();
        this.port = n;
        this.mappedPort = n;
        try {
            this.sock = sIPMessageStack.getNetworkLayer().createDatagramSocket(n, sIPMessageStack.stackInetAddress);
            this.sock.setReceiveBufferSize(8192);
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getPort() {
        return this.mappedPort;
    }

    public void start() throws IOException {
        if (this.sipStack.stunServerAddress != null) {
            try {
                String string = this.sipStack.stunServerAddress;
                Class<?> clazz = Class.forName("net.java.stun4j.StunAddress");
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UDPMessageProcessor.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this.sipStack.stunServerAddress, new Integer(this.sipStack.stunServerPort)};
                Object object = constructor.newInstance(objectArray);
                Class<?> clazz2 = Class.forName("net.java.stun4j.client.SimpleAddressDetector");
                Class[] classArray2 = new Class[]{clazz};
                constructor = clazz2.getConstructor(classArray2);
                Object[] objectArray2 = new Object[]{object};
                Object obj = constructor.newInstance(objectArray2);
                Method method = clazz2.getMethod("start", null);
                method.invoke(obj, null);
                Class[] classArray3 = new Class[]{class$java$net$DatagramSocket == null ? (class$java$net$DatagramSocket = UDPMessageProcessor.class$("java.net.DatagramSocket")) : class$java$net$DatagramSocket};
                method = clazz2.getMethod("getMappingFor", classArray3);
                Object[] objectArray3 = new Object[]{this.sock};
                object = method.invoke(obj, objectArray3);
                method = clazz.getMethod("getHostName", null);
                String string2 = (String)method.invoke(object, null);
                method = clazz.getMethod("getPort", null);
                Character c = (Character)method.invoke(object, null);
                this.mappedPort = c.charValue();
                this.sipStack.setHostAddress(string2);
            }
            catch (Throwable throwable) {
                if (LogWriter.needsLogging) {
                    this.sipStack.getLogWriter().logMessage("Stun initializationFailed");
                    this.sipStack.getLogWriter().logException(throwable);
                }
                System.out.println("Stun stack initialization failed!");
            }
        }
        this.isRunning = true;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName("UDPMessageProcessorThread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Object object;
        int n;
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (n = 0; n < this.sipStack.threadPoolSize; ++n) {
                object = new UDPMessageChannel(this.sipStack, this);
                this.messageChannels.add(object);
            }
        }
        while (this.isRunning) {
            try {
                n = this.sock.getReceiveBufferSize();
                object = new byte[n];
                DatagramPacket datagramPacket = new DatagramPacket((byte[])object, n);
                this.sock.receive(datagramPacket);
                if (this.sipStack.threadPoolSize != -1) {
                    LinkedList linkedList = this.messageQueue;
                    // MONITORENTER : linkedList
                    this.messageQueue.addLast(datagramPacket);
                    this.messageQueue.notify();
                    // MONITOREXIT : linkedList
                    continue;
                }
                new UDPMessageChannel(this.sipStack, this, datagramPacket);
            }
            catch (SocketException socketException) {
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Stopping");
                }
                this.isRunning = false;
                LinkedList linkedList = this.messageQueue;
                object = linkedList;
                // MONITORENTER : linkedList
                this.messageQueue.notifyAll();
                // MONITOREXIT : object
            }
            catch (IOException iOException) {
                this.isRunning = false;
                iOException.printStackTrace();
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Got an IO Exception");
            }
        }
        return;
        {
            catch (Exception exception) {
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Unexpected Exception - quitting");
                }
                InternalErrorHandler.handleException(exception);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.isRunning = false;
            this.messageQueue.notifyAll();
            this.listeningPoint = null;
            this.sock.close();
        }
    }

    public String getTransport() {
        return "udp";
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort hostPort) throws UnknownHostException {
        return new UDPMessageChannel(hostPort.getInetAddress(), hostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(InetAddress inetAddress, int n) throws IOException {
        return new UDPMessageChannel(inetAddress, n, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUse() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            return this.messageQueue.size() != 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

