/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.sip.PeerUnavailableException;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;

public class SipFactory {
    private String pathName = "gov.nist";
    private List sipStackList = null;
    private SipStack sipStack = null;
    private MessageFactory messageFactory = null;
    private HeaderFactory headerFactory = null;
    private AddressFactory addressFactory = null;
    private static SipFactory myFactory = null;

    public static synchronized SipFactory getInstance() {
        if (myFactory == null) {
            myFactory = new SipFactory();
        }
        return myFactory;
    }

    public SipStack createSipStack(Properties properties) throws PeerUnavailableException {
        if (properties == null) {
            throw new NullPointerException("Empty Properties file");
        }
        if (properties.getProperty("javax.sip.IP_ADDRESS") == null) {
            throw new PeerUnavailableException("IP address property missing");
        }
        if (this.sipStackList == null) {
            this.sipStackList = new LinkedList();
            this.sipStack = this.createStack(properties);
        } else {
            int n = 0;
            for (n = 0; n < this.sipStackList.size(); ++n) {
                if (!((SipStack)this.sipStackList.get(n)).getIPAddress().equals(properties.getProperty("javax.sip.IP_ADDRESS"))) continue;
                this.sipStack = (SipStack)this.sipStackList.get(n);
                break;
            }
            if (n == this.sipStackList.size()) {
                this.sipStack = this.createStack(properties);
            }
        }
        return this.sipStack;
    }

    public MessageFactory createMessageFactory() throws PeerUnavailableException {
        if (this.messageFactory == null) {
            this.messageFactory = (MessageFactory)this.createSipFactory("javax.sip.message.MessageFactoryImpl");
        }
        return this.messageFactory;
    }

    public HeaderFactory createHeaderFactory() throws PeerUnavailableException {
        if (this.headerFactory == null) {
            this.headerFactory = (HeaderFactory)this.createSipFactory("javax.sip.header.HeaderFactoryImpl");
        }
        return this.headerFactory;
    }

    public AddressFactory createAddressFactory() throws PeerUnavailableException {
        if (this.addressFactory == null) {
            this.addressFactory = (AddressFactory)this.createSipFactory("javax.sip.address.AddressFactoryImpl");
        }
        return this.addressFactory;
    }

    public void setPathName(String string) {
        this.pathName = string;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void resetFactory() {
        this.sipStackList = null;
        this.messageFactory = null;
        this.headerFactory = null;
        this.addressFactory = null;
    }

    private Object createSipFactory(String string) throws PeerUnavailableException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz = Class.forName(this.getPathName() + "." + string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            String string2 = "The Peer JAIN SIP Factory: " + this.getPathName() + "." + string + " could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(string2, exception);
        }
    }

    private SipStack createStack(Properties properties) throws PeerUnavailableException {
        try {
            Class[] classArray = new Class[]{Class.forName("java.util.Properties")};
            Constructor<?> constructor = Class.forName(this.getPathName() + ".javax.sip.SipStackImpl").getConstructor(classArray);
            Object[] objectArray = new Object[]{properties};
            this.sipStack = (SipStack)constructor.newInstance(objectArray);
            this.sipStackList.add(this.sipStack);
            return this.sipStack;
        }
        catch (Exception exception) {
            String string = "The Peer SIP Stack: " + this.getPathName() + ".javax.sip.SipStackImpl" + " could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(string, exception);
        }
    }

    private SipFactory() {
    }
}

