/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class TransactionState
implements Serializable {
    private int m_transactionState;
    private static int m_size = 6;
    private static TransactionState[] m_transStateArray = new TransactionState[m_size];
    public static final int _CALLING = 0;
    public static final TransactionState CALLING = new TransactionState(0);
    public static final int _TRYING = 1;
    public static final TransactionState TRYING = new TransactionState(1);
    public static final int _PROCEEDING = 2;
    public static final TransactionState PROCEEDING = new TransactionState(2);
    public static final int _COMPLETED = 3;
    public static final TransactionState COMPLETED = new TransactionState(3);
    public static final int _CONFIRMED = 4;
    public static final TransactionState CONFIRMED = new TransactionState(4);
    public static final int _TERMINATED = 5;
    public static final TransactionState TERMINATED = new TransactionState(5);

    private TransactionState(int n) {
        this.m_transactionState = n;
        TransactionState.m_transStateArray[this.m_transactionState] = this;
    }

    public static TransactionState getObject(int n) {
        if (n >= 0 && n < m_size) {
            return m_transStateArray[n];
        }
        throw new IllegalArgumentException("Invalid transactionState value");
    }

    public int getValue() {
        return this.m_transactionState;
    }

    private Object readResolve() throws ObjectStreamException {
        return m_transStateArray[this.m_transactionState];
    }

    public String toString() {
        String string = "";
        switch (this.m_transactionState) {
            case 0: {
                string = "Calling Transaction";
                break;
            }
            case 1: {
                string = "Trying Transaction";
                break;
            }
            case 2: {
                string = "Proceeding Transaction";
                break;
            }
            case 3: {
                string = "Completed Transaction";
                break;
            }
            case 4: {
                string = "Confirmed Transaction";
                break;
            }
            case 5: {
                string = "Terminated Transaction";
                break;
            }
            default: {
                string = "Error while printing Transaction State";
            }
        }
        return string;
    }
}

