/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core.net;

import gov.nist.core.net.NetworkLayer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultNetworkLayer
implements NetworkLayer {
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
    public static final DefaultNetworkLayer SINGLETON = new DefaultNetworkLayer();

    private DefaultNetworkLayer() {
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new ServerSocket(n, n2, inetAddress);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new Socket(inetAddress, n);
    }

    public DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket();
    }

    public DatagramSocket createDatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        return new DatagramSocket(n, inetAddress);
    }

    public SSLServerSocket createSSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(n, n2, inetAddress);
    }

    public SSLSocket createSSLSocket(InetAddress inetAddress, int n) throws IOException {
        return (SSLSocket)this.sslSocketFactory.createSocket(inetAddress, n);
    }

    public SSLSocket createSSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2) throws IOException {
        return (SSLSocket)this.sslSocketFactory.createSocket(inetAddress, n, inetAddress2, 0);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2) throws IOException {
        return new Socket(inetAddress, n, inetAddress2, 0);
    }
}

