/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.util.EventObject;
import java.util.LinkedList;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;

class EventScanner
implements Runnable {
    private boolean isStopped;
    protected int refCount;
    private LinkedList pendingEvents = new LinkedList();
    private int[] eventMutex = new int[]{0};
    private SipStackImpl sipStackImpl;

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedList();
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        this.sipStackImpl = sipStackImpl;
        thread.setName("EventScannerThread");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.pendingEvents.add(eventWrapper);
            this.eventMutex.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        if (this.refCount > 0) {
            --this.refCount;
        }
        if (this.refCount != 0) return;
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.isStopped = true;
            this.eventMutex.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverEvent(EventWrapper eventWrapper) {
        EventObject eventObject = eventWrapper.sipEvent;
        SipListener sipListener = ((SipProviderImpl)eventObject.getSource()).sipListener;
        if (eventObject instanceof RequestEvent) {
            Object object;
            SIPRequest sIPRequest = (SIPRequest)((RequestEvent)eventObject).getRequest();
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("deliverEvent : " + sIPRequest.getFirstLine() + " transaction " + eventWrapper.transaction);
            }
            if (this.sipStackImpl.isDialogCreated(sIPRequest.getMethod())) {
                object = (SIPServerTransaction)this.sipStackImpl.findTransaction(sIPRequest, true);
                SIPDialog sIPDialog = this.sipStackImpl.getDialog(sIPRequest.getDialogId(true));
                EventScanner eventScanner = this;
                synchronized (eventScanner) {
                    if (object != null && !((SIPServerTransaction)object).passToListener()) {
                        if (LogWriter.needsLogging) {
                            this.sipStackImpl.logMessage("transaction already exists! " + object);
                        }
                        return;
                    }
                    if (this.sipStackImpl.findPendingTransaction(sIPRequest) != null) {
                        if (LogWriter.needsLogging) {
                            this.sipStackImpl.logMessage("transaction already exists!!");
                        }
                        return;
                    }
                    SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)eventWrapper.transaction;
                    this.sipStackImpl.putPendingTransaction(sIPServerTransaction);
                }
            } else if (!sIPRequest.getMethod().equals("CANCEL") && this.sipStackImpl.getDialog(sIPRequest.getDialogId(true)) == null && (object = this.sipStackImpl.findTransaction(sIPRequest, true)) != null) {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("transaction already exists!");
                }
                return;
            }
            sIPRequest.setTransaction(eventWrapper.transaction);
            if (sIPRequest.getMethod().equals("CANCEL")) {
                object = this.sipStackImpl.findCancelTransaction(sIPRequest, true);
                if (object != null && ((SIPTransaction)object).getState() == SIPTransaction.TERMINATED_STATE) {
                    if (LogWriter.needsLogging) {
                        this.sipStackImpl.logMessage("Too late to cancel Transaction");
                    }
                    try {
                        ((SIPTransaction)object).sendMessage(sIPRequest.createResponse(200));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Cancel transaction = " + object);
                }
            }
            try {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Calling listener " + sIPRequest.getFirstLine());
                    this.sipStackImpl.logMessage("Calling listener " + eventWrapper.transaction);
                }
                if (sipListener != null) {
                    sipListener.processRequest((RequestEvent)eventObject);
                }
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Done processing Message " + sIPRequest.getFirstLine());
                }
                this.sipStackImpl.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                if (eventWrapper.transaction != null && (object = (SIPDialog)eventWrapper.transaction.getDialog()) != null) {
                    ((SIPDialog)object).requestConsumed();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (eventWrapper.transaction != null) {
                ((SIPServerTransaction)eventWrapper.transaction).clearPending();
            }
        } else if (eventObject instanceof ResponseEvent) {
            Object object;
            try {
                if (LogWriter.needsLogging) {
                    object = (SIPResponse)((ResponseEvent)eventObject).getResponse();
                    this.sipStackImpl.logMessage("Calling listener for " + ((SIPResponse)object).getFirstLine());
                }
                if (sipListener != null) {
                    sipListener.processResponse((ResponseEvent)eventObject);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = (SIPClientTransaction)eventWrapper.transaction;
            if (object != null && TransactionState.COMPLETED == ((SIPTransaction)object).getState() && ((SIPTransaction)object).getOriginalRequest() != null && !((SIPTransaction)object).getOriginalRequest().getMethod().equals("INVITE")) {
                ((SIPClientTransaction)object).clearState();
            }
            if (object != null) {
                ((SIPClientTransaction)object).clearPending();
            }
        } else if (eventObject instanceof TimeoutEvent) {
            try {
                if (sipListener != null) {
                    sipListener.processTimeout((TimeoutEvent)eventObject);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (eventWrapper.transaction != null) {
                eventWrapper.transaction.clearPending();
            }
        } else if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("bad event" + eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block4: while (true) {
            Object var1_1 = null;
            EventWrapper eventWrapper = null;
            Object object = this.eventMutex;
            // MONITORENTER : this.eventMutex
            while (this.pendingEvents.isEmpty()) {
                if (this.isStopped) {
                    if (LogWriter.needsLogging) {
                        this.sipStackImpl.logMessage("Stopped event scanner!!");
                    }
                    // MONITOREXIT : object
                    return;
                }
                try {
                    this.eventMutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.sipStackImpl.logMessage("Interrupted!");
                    // MONITOREXIT : object
                    return;
                }
            }
            LinkedList linkedList = this.pendingEvents;
            this.pendingEvents = new LinkedList();
            // MONITOREXIT : object
            object = linkedList.listIterator();
            while (true) {
                if (!object.hasNext()) continue block4;
                eventWrapper = (EventWrapper)object.next();
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Processing " + eventWrapper + "nevents " + linkedList.size());
                }
                this.deliverEvent(eventWrapper);
            }
            break;
        }
    }
}

