/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.util.EventObject;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class NistSipMessageHandlerImpl
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    protected SipStackImpl sipStackImpl;
    private SIPRequest pendingRequest;
    private MessageChannel pendingMessageChannel;

    public void processPending() {
        this.processRequest(this.pendingRequest, this.pendingMessageChannel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        RequestEvent requestEvent;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SipProviderImpl sipProviderImpl;
        SipStackImpl sipStackImpl;
        SIPTransactionStack sIPTransactionStack;
        block50: {
            block54: {
                block55: {
                    block52: {
                        block53: {
                            if (LogWriter.needsLogging) {
                                this.sipStackImpl.logMessage("PROCESSING INCOMING REQUEST " + sIPRequest.getFirstLine());
                            }
                            if (this.listeningPoint == null) {
                                if (!LogWriter.needsLogging) return;
                                this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
                                return;
                            }
                            sIPTransactionStack = (SIPTransactionStack)this.transactionChannel.getSIPStack();
                            sipStackImpl = (SipStackImpl)sIPTransactionStack;
                            sipProviderImpl = this.listeningPoint.getProvider();
                            if (sipProviderImpl == null) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("No provider - dropping !!");
                                return;
                            }
                            SipListener sipListener = sipProviderImpl.sipListener;
                            if (sIPRequest.getHeader("Route") != null && sipStackImpl.stripRouteHeader) {
                                object4 = sIPRequest.getRouteHeaders();
                                object3 = (Route)((SIPHeaderList)object4).getFirst();
                                object2 = (SipUri)((AddressParametersHeader)object3).getAddress().getURI();
                                int n = ((SipUri)object2).getHostPort().hasPort() ? ((SipUri)object2).getHostPort().getPort() : 5060;
                                object = ((SipUri)object2).getHost();
                                if (((String)object).equals(this.listeningPoint.getHost()) && n == this.listeningPoint.getPort()) {
                                    if (((SIPHeaderList)object4).size() == 1) {
                                        sIPRequest.removeHeader("Route");
                                    } else {
                                        ((SIPHeaderList)object4).removeFirst();
                                    }
                                }
                            }
                            object4 = this.transactionChannel;
                            if (!sIPRequest.getMethod().equalsIgnoreCase("ACK")) break block52;
                            object3 = sIPRequest.getDialogId(true);
                            object2 = sipStackImpl.getDialog((String)object3);
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Processing ACK for dialog " + object2);
                            }
                            if (object2 != null) break block53;
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Dialog does not exist " + sIPRequest.getFirstLine() + " isServerTransaction = " + true);
                            }
                            object4 = sipStackImpl.findTransaction(sIPRequest, true);
                            break block50;
                        }
                        if (((SIPDialog)object2).isAckSeen() && ((SIPDialog)object2).getRemoteSequenceNumber() == sIPRequest.getCSeq().getSequenceNumber()) {
                            if (sipStackImpl.isRetransmissionFilterActive()) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("Retransmission Filter enabled - dropping Ack retransmission");
                                return;
                            }
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("ACK retransmission for 2XX response Sending ACK to the TU");
                            }
                            ((SIPTransaction)object4).setDialog((SIPDialog)object2);
                            break block50;
                        } else {
                            SIPServerTransaction sIPServerTransaction = ((SIPDialog)object2).getInviteTransaction();
                            Object object5 = object = sIPServerTransaction != null ? sIPServerTransaction.getLastResponse() : null;
                            if (sIPServerTransaction != null && object != null && ((SIPResponse)object).getStatusCode() / 100 == 2 && ((SIPMessage)object).getCSeq().getMethod().equals("INVITE") && ((SIPMessage)object).getCSeq().getSequenceNumber() == sIPRequest.getCSeq().getSequenceNumber()) {
                                ((SIPTransaction)object4).setDialog((SIPDialog)object2);
                                ((SIPDialog)object2).ackReceived(sIPRequest);
                                sipStackImpl.logMessage("ACK for 2XX response --- sending to TU ");
                                break block50;
                            } else {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage(" INVITE transaction not found  -- Discarding ACK");
                                return;
                            }
                        }
                    }
                    if (!sIPRequest.getMethod().equals("BYE")) break block54;
                    object4 = this.transactionChannel;
                    if (object4 == null || !((SIPServerTransaction)object4).isTransactionMapped()) break block55;
                    object3 = sIPRequest.getDialogId(true);
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("dialogId = " + (String)object3);
                    }
                    if ((object2 = sipStackImpl.getDialog((String)object3)) != null) {
                        if (!((SIPDialog)object2).isRequestConsumable(sIPRequest)) {
                            sIPTransactionStack.removeTransaction((SIPTransaction)object4);
                            if (!LogWriter.needsLogging) return;
                            sipStackImpl.logMessage("Dropping bye  for " + (String)object3);
                            return;
                        }
                        ((SIPDialog)object2).addTransaction((SIPTransaction)object4);
                    }
                    break block50;
                }
                if (object4 != null) {
                    object3 = sIPRequest.getDialogId(true);
                    object2 = sIPTransactionStack.getDialog((String)object3);
                    if (object2 != null) {
                        if (!LogWriter.needsLogging) return;
                        sipStackImpl.logMessage("Dropping out of sequence BYE");
                        return;
                    }
                    if (sipStackImpl.dialogSupport) {
                        object4 = null;
                    }
                }
                break block50;
            }
            if (sIPRequest.getRequestLine().getMethod().equals("CANCEL")) {
                object3 = (SIPServerTransaction)sIPTransactionStack.findCancelTransaction(sIPRequest, true);
                if (object3 == null) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("transaction  does not exist " + sIPRequest.getFirstLine() + "isServerTransaction = " + true);
                    }
                    object4 = null;
                } else {
                    object4 = object3;
                }
            } else if (sIPRequest.getMethod().equals("INVITE")) {
                SIPTransaction sIPTransaction;
                object3 = sIPRequest.getDialogId(true);
                object2 = sIPTransactionStack.getDialog((String)object3);
                SIPTransaction sIPTransaction2 = sIPTransaction = object2 == null ? null : ((SIPDialog)object2).getInviteTransaction();
                if (object2 != null && object4 != null && sIPTransaction != null && sIPRequest.getCSeq().getSequenceNumber() > ((SIPDialog)object2).getRemoteSequenceNumber() && sIPTransaction instanceof SIPServerTransaction && sIPTransaction.isInviteTransaction() && sIPTransaction.getState() != TransactionState.COMPLETED && sIPTransaction.getState() != TransactionState.TERMINATED && sIPTransaction.getState() != TransactionState.CONFIRMED) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                    }
                    object = sIPRequest.createResponse(500);
                    RetryAfter retryAfter = new RetryAfter();
                    try {
                        retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        invalidArgumentException.printStackTrace();
                    }
                    ((SIPMessage)object).addHeader(retryAfter);
                    try {
                        ((SIPTransaction)object4).sendMessage((SIPMessage)object);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                SIPTransaction sIPTransaction3 = sIPTransaction = object2 == null ? null : ((SIPDialog)object2).getLastTransaction();
                if (object2 != null && sIPTransaction != null && sIPTransaction.isInviteTransaction() && sIPTransaction instanceof SIPClientTransaction && sIPTransaction.getState() != TransactionState.COMPLETED && sIPTransaction.getState() != TransactionState.TERMINATED) {
                    if (((SIPDialog)object2).getRemoteSequenceNumber() + 1 != sIPRequest.getCSeq().getSequenceNumber()) {
                        if (!LogWriter.needsLogging) return;
                        sipStackImpl.logMessage("Dropping message -- sequence number is too high!");
                        return;
                    }
                    ((SIPDialog)object2).setRemoteSequenceNumber(sIPRequest.getCSeq().getSequenceNumber());
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Sending 491 response for out of sequence message");
                    }
                    object = sIPRequest.createResponse(491);
                    try {
                        ((SIPTransaction)object4).sendMessage((SIPMessage)object);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ((SIPDialog)object2).requestConsumed();
                    return;
                }
            }
        }
        if (LogWriter.needsLogging) {
            sipStackImpl.logMessage("-----------------");
            sipStackImpl.logMessage(sIPRequest.encodeMessage());
        }
        if (!((object2 = sipStackImpl.getDialog((String)(object3 = sIPRequest.getDialogId(true)))) == null || object4 == null || sIPRequest.getMethod().equals("BYE") || sIPRequest.getMethod().equals("CANCEL") || sIPRequest.getMethod().equals("ACK"))) {
            if (((SIPDialog)object2).getRemoteSequenceNumber() >= sIPRequest.getCSeq().getSequenceNumber()) {
                if (LogWriter.needsLogging) {
                    sipStackImpl.logMessage("Dropping out of sequence message " + ((SIPDialog)object2).getRemoteSequenceNumber() + " " + sIPRequest.getCSeq());
                }
                if (((SIPDialog)object2).getRemoteSequenceNumber() <= sIPRequest.getCSeq().getSequenceNumber()) return;
                if (LogWriter.needsLogging) {
                    sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                }
                SIPResponse sIPResponse = sIPRequest.createResponse(500);
                try {
                    ((SIPTransaction)object4).sendMessage(sIPResponse);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (!((SIPDialog)object2).isRequestConsumable(sIPRequest)) {
                return;
            }
            ((SIPDialog)object2).addTransaction((SIPTransaction)object4);
            ((SIPDialog)object2).addRoute(sIPRequest);
        }
        if (object2 == null && sIPRequest.getMethod().equals("NOTIFY")) {
            object = sIPTransactionStack.findSubscribeTransaction(sIPRequest);
            if (object != null) {
                ((SIPTransaction)object4).setDialog((SIPDialog)((SIPTransaction)object).getDialog());
                requestEvent = ((SIPTransaction)object).getDialog().getState() == null ? new RequestEvent((Object)sipProviderImpl, null, (Request)sIPRequest) : new RequestEvent((Object)sipProviderImpl, (ServerTransaction)object4, (Request)sIPRequest);
            } else {
                requestEvent = new RequestEvent((Object)sipProviderImpl, null, (Request)sIPRequest);
            }
        } else {
            requestEvent = object4 != null && ((SIPServerTransaction)object4).isTransactionMapped() ? new RequestEvent((Object)sipProviderImpl, (ServerTransaction)object4, (Request)sIPRequest) : new RequestEvent((Object)sipProviderImpl, null, (Request)sIPRequest);
        }
        sipProviderImpl.handleEvent((EventObject)requestEvent, (SIPTransaction)object4);
    }

    public void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("PROCESSING INCOMING RESPONSE" + sIPResponse.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
            }
            return;
        }
        SIPTransaction sIPTransaction = this.transactionChannel;
        SipProviderImpl sipProviderImpl = this.listeningPoint.getProvider();
        if (sipProviderImpl == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message:  no provider");
            }
            return;
        }
        SipStackImpl sipStackImpl = sipProviderImpl.sipStack;
        if (LogWriter.needsLogging) {
            sipStackImpl.logMessage("Transaction = " + sIPTransaction);
        }
        if (this.transactionChannel == null) {
            String string = sIPResponse.getDialogId(false);
            SIPDialog sIPDialog = sipStackImpl.getDialog(string);
            if (sipProviderImpl.sipListener == null) {
                return;
            }
            if (sIPDialog != null) {
                if (sIPResponse.getStatusCode() != 200) {
                    return;
                }
                if (sipStackImpl.isRetransmissionFilterActive() && sIPResponse.getCSeq().getSequenceNumber() == ((SIPTransaction)sIPDialog.getFirstTransaction()).getCSeq() && sIPResponse.getCSeq().getMethod().equals(((SIPTransaction)sIPDialog.getFirstTransaction()).getMethod())) {
                    try {
                        sIPDialog.resendAck();
                        return;
                    }
                    catch (SipException sipException) {
                        // empty catch block
                    }
                }
            }
            ResponseEvent responseEvent = new ResponseEvent((Object)sipProviderImpl, null, (Response)sIPResponse);
            sipProviderImpl.handleEvent((EventObject)responseEvent, sIPTransaction);
            return;
        }
        SipListener sipListener = sipProviderImpl.sipListener;
        ResponseEvent responseEvent = new ResponseEvent((Object)sipProviderImpl, (ClientTransaction)sIPTransaction, (Response)sIPResponse);
        sipProviderImpl.handleEvent((EventObject)responseEvent, sIPTransaction);
    }

    public String getProcessingInfo() {
        return null;
    }
}

