/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public final class SipProviderImpl
implements SipProvider,
SIPTransactionEventListener {
    protected SipListener sipListener;
    protected boolean isActive;
    protected SipStackImpl sipStack;
    protected ListeningPointImpl listeningPoint;
    protected EventScanner eventScanner;

    protected void stop() {
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Exiting provider");
        }
        this.listeningPoint.removeSipProvider();
        this.eventScanner.stop();
    }

    public void handleEvent(EventObject eventObject, SIPTransaction sIPTransaction) {
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("handleEvent " + eventObject + "currentTransaction = " + sIPTransaction + "this.sipListener = " + this.sipListener + "sipEvent.source = " + eventObject.getSource());
            this.sipStack.logStackTrace();
        }
        EventWrapper eventWrapper = new EventWrapper();
        eventWrapper.sipEvent = eventObject;
        eventWrapper.transaction = sIPTransaction;
        if (sIPTransaction != null) {
            sIPTransaction.setEventPending();
        }
        if (!this.sipStack.reEntrantListener) {
            this.eventScanner.addEvent(eventWrapper);
        } else {
            this.eventScanner.deliverEvent(eventWrapper);
        }
    }

    protected SipProviderImpl(EventScanner eventScanner) {
        this.eventScanner = eventScanner;
        ++this.eventScanner.refCount;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        SipProviderImpl sipProviderImpl;
        Iterator iterator;
        SipStackImpl sipStackImpl = this.sipStack;
        synchronized (sipStackImpl) {
            iterator = this.sipStack.getSipProviders();
            while (iterator.hasNext()) {
                sipProviderImpl = (SipProviderImpl)iterator.next();
                if (sipProviderImpl.sipListener == null || sipProviderImpl.sipListener == sipListener) continue;
                throw new TooManyListenersException();
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
        sipStackImpl = this.sipStack;
        synchronized (sipStackImpl) {
            iterator = this.sipStack.getSipProviders();
            while (iterator.hasNext()) {
                sipProviderImpl = (SipProviderImpl)iterator.next();
                sipProviderImpl.sipListener = sipListener;
            }
        }
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public CallIdHeader getNewCallId() {
        String string = Utils.generateCallIdentifier(this.getSipStack().getIPAddress());
        CallID callID = new CallID();
        try {
            callID.setCallId(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return callID;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        UnknownHostException unknownHostException;
        SIPRequest sIPRequest;
        block27: {
            Object object;
            Object object2;
            Object object3;
            if (request == null) {
                throw new NullPointerException("null request");
            }
            sIPRequest = (SIPRequest)request;
            if (sIPRequest.getTransaction() != null) {
                throw new TransactionUnavailableException("Transaction already assigned to request");
            }
            if (sIPRequest.getTopmostVia() != null) {
                object3 = sIPRequest.getTopmostVia().getSentBy();
                int n = ((HostPort)object3).getPort() == -1 ? 5060 : ((HostPort)object3).getPort();
                object2 = this.sipStack.getListeningPoints();
                boolean bl = false;
                while (object2.hasNext()) {
                    object = (ListeningPoint)object2.next();
                    if (object.getPort() != n || !object.getTransport().equalsIgnoreCase(sIPRequest.getTopmostVia().getTransport())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new TransactionUnavailableException(" No listening point for " + sIPRequest.getTopmostVia().getTransport() + " at port " + n);
                }
            }
            if (request.getMethod().equalsIgnoreCase("CANCEL") && (object3 = (SIPClientTransaction)this.sipStack.findCancelTransaction((SIPRequest)request, false)) != null) {
                SIPClientTransaction sIPClientTransaction = this.sipStack.createClientTransaction(((SIPTransaction)object3).getMessageChannel());
                ((SIPTransaction)sIPClientTransaction).setOriginalRequest((SIPRequest)request);
                ((SIPTransaction)sIPClientTransaction).addEventListener(this);
                this.sipStack.addTransaction(sIPClientTransaction);
                sIPClientTransaction.setDialog((SIPDialog)((SIPTransaction)object3).getDialog());
                return sIPClientTransaction;
            }
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("could not find existing transaction for " + ((SIPRequest)request).getFirstLine());
            }
            object3 = this.sipStack.getRouter().getNextHops(request);
            String string = sIPRequest.getDialogId(false);
            object2 = this.sipStack.getDialog(string);
            unknownHostException = null;
            if (object3 == null || !object3.hasNext()) {
                if (object2 != null) {
                    try {
                        object = ((SIPDialog)object2).getNextHop();
                        if (object != null) {
                            SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.sipStack.createMessageChannel(this.listeningPoint.port, (Hop)object);
                            String string2 = Utils.generateBranchId();
                            if (sIPRequest.getTopmostVia() != null) {
                                sIPRequest.getTopmostVia().setBranch(string2);
                            } else {
                                Via via = this.listeningPoint.messageProcessor.getViaHeader();
                                sIPRequest.addHeader(via);
                            }
                            sIPClientTransaction.setOriginalRequest(sIPRequest);
                            sIPClientTransaction.setBranch(string2);
                            sIPClientTransaction.setDialog((SIPDialog)object2);
                            sIPClientTransaction.addEventListener(this);
                            return sIPClientTransaction;
                        }
                        break block27;
                    }
                    catch (Exception exception) {
                        throw new TransactionUnavailableException(exception.getMessage());
                    }
                }
                throw new TransactionUnavailableException("no route!");
            }
            while (object3.hasNext()) {
                object = (Hop)object3.next();
                try {
                    SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.sipStack.createMessageChannel(this.listeningPoint.port, (Hop)object);
                    if (sIPClientTransaction == null) continue;
                    String string3 = Utils.generateBranchId();
                    if (sIPRequest.getTopmostVia() != null) {
                        sIPRequest.getTopmostVia().setBranch(string3);
                    } else {
                        Via via = this.listeningPoint.messageProcessor.getViaHeader();
                        sIPRequest.addHeader(via);
                    }
                    sIPClientTransaction.setOriginalRequest(sIPRequest);
                    sIPClientTransaction.setBranch(string3);
                    if (this.sipStack.isDialogCreated(request.getMethod())) {
                        if (object2 != null) {
                            sIPClientTransaction.setDialog((SIPDialog)object2);
                        } else if (this.sipStack.dialogSupport) {
                            this.sipStack.createDialog(sIPClientTransaction);
                        }
                    } else {
                        sIPClientTransaction.setDialog((SIPDialog)object2);
                    }
                    sIPClientTransaction.addEventListener(this);
                    return sIPClientTransaction;
                }
                catch (UnknownHostException unknownHostException2) {
                    unknownHostException = unknownHostException2;
                }
                catch (ParseException parseException) {
                    InternalErrorHandler.handleException(parseException);
                }
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Error processing " + sIPRequest);
        }
        if (unknownHostException == null) {
            throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ");
        }
        throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ", (Throwable)unknownHostException);
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        SIPServerTransaction sIPServerTransaction = null;
        SIPRequest sIPRequest = (SIPRequest)request;
        if (this.sipStack.isDialogCreated(sIPRequest.getMethod()) && this.sipStack.dialogSupport) {
            if (this.sipStack.findTransaction((SIPRequest)request, true) != null) {
                throw new TransactionAlreadyExistsException("server transaction already exists!");
            }
            if (!this.sipStack.hasResources()) {
                throw new TransactionUnavailableException("Resource Not available!");
            }
            sIPServerTransaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (sIPServerTransaction == null) {
                throw new TransactionUnavailableException("Transaction not available");
            }
            if (sIPServerTransaction.getOriginalRequest() == null) {
                sIPServerTransaction.setOriginalRequest(sIPRequest);
            }
            try {
                this.sipStack.addTransaction(sIPServerTransaction);
            }
            catch (IOException iOException) {
                throw new TransactionUnavailableException("Error sending provisional response");
            }
            sIPServerTransaction.addEventListener(this);
            String string = sIPRequest.getDialogId(true);
            SIPDialog sIPDialog = this.sipStack.getDialog(string);
            if (sIPDialog == null) {
                sIPDialog = this.sipStack.createDialog(sIPServerTransaction);
            } else {
                sIPServerTransaction.setDialog(sIPDialog);
            }
            sIPDialog.setStack(this.sipStack);
            sIPDialog.addRoute(sIPRequest);
            if (sIPDialog.getRemoteTag() != null && sIPDialog.getLocalTag() != null) {
                this.sipStack.putDialog(sIPDialog);
            }
        } else {
            sIPServerTransaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
            if (sIPServerTransaction != null) {
                throw new TransactionAlreadyExistsException("Transaction exists! ");
            }
            sIPServerTransaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (sIPServerTransaction == null) {
                throw new TransactionUnavailableException("Transaction not available!");
            }
            if (sIPServerTransaction.getOriginalRequest() == null) {
                sIPServerTransaction.setOriginalRequest(sIPRequest);
            }
            try {
                this.sipStack.addTransaction(sIPServerTransaction);
            }
            catch (IOException iOException) {
                throw new TransactionUnavailableException("Could not send back provisional response!");
            }
            String string = sIPRequest.getDialogId(true);
            SIPDialog sIPDialog = this.sipStack.getDialog(string);
            if (sIPDialog != null) {
                sIPDialog.addTransaction(sIPServerTransaction);
                sIPDialog.addRoute(sIPRequest);
            }
        }
        return sIPServerTransaction;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
    }

    public void sendRequest(Request request) throws SipException {
        ListIterator listIterator = this.sipStack.getRouter().getNextHops(request);
        if (listIterator == null || !listIterator.hasNext()) {
            throw new SipException("could not determine next hop!");
        }
        if (((SIPRequest)request).getTopmostVia() == null) {
            throw new SipException("Invalid SipRequest -- no via header!");
        }
        SIPTransaction sIPTransaction = this.sipStack.findTransaction((SIPRequest)request, false);
        if (sIPTransaction != null) {
            throw new SipException("Cannot send statelessly Transaction found!");
        }
        while (listIterator.hasNext()) {
            Hop hop = (Hop)listIterator.next();
            try {
                SIPRequest sIPRequest = (SIPRequest)request;
                String string = sIPRequest.getTransactionId();
                Via via = sIPRequest.getTopmostVia();
                via.setBranch(string);
                SIPRequest sIPRequest2 = sIPRequest;
                MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.listeningPoint.port, hop);
                if (messageChannel == null) continue;
                messageChannel.sendMessage(sIPRequest2);
                return;
            }
            catch (IOException iOException) {
                if (!LogWriter.needsLogging) continue;
                this.sipStack.getLogWriter().logException(iOException);
            }
            catch (ParseException parseException) {
                InternalErrorHandler.handleException(parseException);
            }
        }
        throw new SipException("could not forward request");
    }

    public void sendResponse(Response response) throws SipException {
        int n;
        SIPResponse sIPResponse = (SIPResponse)response;
        Via via = sIPResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!");
        }
        String string = via.getTransport();
        String string2 = via.getReceived();
        if (string2 == null) {
            string2 = via.getHost();
        }
        if ((n = via.getrport()) == -1 && (n = via.getPort()) == -1) {
            n = string.equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        if (string2.indexOf(":") > 0 && string2.indexOf("[") < 0) {
            string2 = "[" + string2 + "]";
        }
        HopImpl hopImpl = new HopImpl(string2, n, string);
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.listeningPoint.port, hopImpl);
            messageChannel.sendMessage(sIPResponse);
        }
        catch (IOException iOException) {
            throw new SipException(iOException.getMessage());
        }
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        listeningPointImpl.sipProviderImpl = this;
        this.listeningPoint = (ListeningPointImpl)listeningPoint;
    }

    public Dialog createDialog(Transaction transaction) throws SipException {
        if (transaction == null) {
            throw new NullPointerException("Null transaction!");
        }
        if (this.sipStack.dialogSupport) {
            throw new SipException("Stack Configuration Error - AUTOMATIC_DIALOG_SUPPORT is on");
        }
        if (!this.sipStack.isDialogCreated(transaction.getRequest().getMethod())) {
            throw new SipException("Dialog cannot be created for this method " + transaction.getRequest().getMethod());
        }
        if (transaction.getDialog() != null) {
            throw new SipException("Dialog is already set! ");
        }
        SIPDialog sIPDialog = null;
        SIPTransaction sIPTransaction = (SIPTransaction)transaction;
        SIPRequest sIPRequest = (SIPRequest)transaction.getRequest();
        if (transaction instanceof ServerTransaction) {
            String string = sIPRequest.getDialogId(true);
            sIPDialog = this.sipStack.getDialog(string);
            if (sIPDialog == null) {
                sIPDialog = this.sipStack.createDialog((SIPTransaction)transaction);
                sIPDialog.addTransaction(sIPTransaction);
                sIPDialog.addRoute(sIPRequest);
            } else {
                sIPTransaction.setDialog(sIPDialog);
            }
        } else {
            if (sIPTransaction.getState() != null) {
                throw new SipException("Cannot create dialog after state is assigned");
            }
            sIPDialog = this.sipStack.createDialog(sIPTransaction);
            sIPTransaction.setDialog(sIPDialog);
        }
        return sIPDialog;
    }

    protected void setSipStack(SipStackImpl sipStackImpl) {
        this.sipStack = sipStackImpl;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent sIPTransactionErrorEvent) {
        SIPTransaction sIPTransaction = (SIPTransaction)sIPTransactionErrorEvent.getSource();
        if (sIPTransactionErrorEvent.getErrorID() == 2) {
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("TransportError occured on " + sIPTransaction);
            }
            Object object = sIPTransactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        } else if (sIPTransactionErrorEvent.getErrorID() == 1) {
            Object object = sIPTransactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        } else if (sIPTransactionErrorEvent.getErrorID() == 3) {
            if (this.sipStack.isRetransmissionFilterActive()) {
                InternalErrorHandler.handleException("Unexpected event !");
            }
            Object object = sIPTransactionErrorEvent.getSource();
            Timeout timeout = Timeout.RETRANSMIT;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        }
    }
}

