/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.header.AuthenticationInfoHeader;

public class AuthenticationInfo
extends ParametersHeader
implements AuthenticationInfoHeader {
    public AuthenticationInfo() {
        super("Authentication-Info");
        this.parameters.setSeparator(",");
    }

    public void add(NameValue nameValue) {
        this.parameters.add(nameValue);
    }

    protected String encodeBody() {
        return this.parameters.encode();
    }

    public NameValue getAuthInfo(String string) {
        return this.parameters.getNameValue(string);
    }

    public String getAuthenticationInfo() {
        return this.encodeBody();
    }

    public String getCNonce() {
        return this.getParameter("cnonce");
    }

    public String getNextNonce() {
        return this.getParameter("nextnonce");
    }

    public int getNonceCount() {
        return this.getParameterAsInt("nc");
    }

    public String getQop() {
        return this.getParameter("qop");
    }

    public String getResponse() {
        return this.getParameter("rspauth");
    }

    public void setCNonce(String string) throws ParseException {
        this.setParameter("cnonce", string);
    }

    public void setNextNonce(String string) throws ParseException {
        this.setParameter("nextnonce", string);
    }

    public void setNonceCount(int n) throws ParseException {
        if (n < 0) {
            throw new ParseException("bad value", 0);
        }
        String string = Integer.toHexString(n);
        String string2 = "00000000";
        string = string2.substring(0, 8 - string.length()) + string;
        this.setParameter("nc", string);
    }

    public void setQop(String string) throws ParseException {
        this.setParameter("qop", string);
    }

    public void setResponse(String string) throws ParseException {
        this.setParameter("response", string);
    }

    public void setParameter(String string, String string2) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        NameValue nameValue = this.parameters.getNameValue(string.toLowerCase());
        if (nameValue == null) {
            nameValue = new NameValue(string, string2);
            if (string.equalsIgnoreCase("qop") || string.equalsIgnoreCase("nextnonce") || string.equalsIgnoreCase("realm") || string.equalsIgnoreCase("cnonce") || string.equalsIgnoreCase("nonce") || string.equalsIgnoreCase("opaque") || string.equalsIgnoreCase("username") || string.equalsIgnoreCase("domain") || string.equalsIgnoreCase("nextnonce") || string.equalsIgnoreCase("rspauth")) {
                if (string2 == null) {
                    throw new NullPointerException("null value");
                }
                if (string2.startsWith("\"")) {
                    throw new ParseException(string2 + " : Unexpected DOUBLE_QUOTE", 0);
                }
                nameValue.setQuotedValue();
            }
            super.setParameter(nameValue);
        } else {
            nameValue.setValue(string2);
        }
    }
}

