/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.header.NameMap;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.AddressParser;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.ParserFactory;
import gov.nist.javax.sip.parser.RequestLineParser;
import gov.nist.javax.sip.parser.StatusLineParser;
import gov.nist.javax.sip.parser.URLParser;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringMsgParser {
    protected boolean readBody = true;
    private String rawMessage;
    private String rawMessage1;
    private String currentMessage;
    private ParseExceptionListener parseExceptionListener;
    private Vector messageHeaders = new Vector(10, 10);
    private int bufferPointer = 0;
    private boolean bodyIsString;
    private byte[] currentMessageBytes;
    protected int contentLength;
    private boolean debugFlag;
    private int currentLine = 0;
    private String currentHeader;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$RequestLine;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$StatusLine;

    public StringMsgParser() {
    }

    public StringMsgParser(ParseExceptionListener parseExceptionListener) {
        this();
        this.parseExceptionListener = parseExceptionListener;
    }

    protected String getMessageBody() {
        String string;
        if (this.contentLength == 0) {
            return null;
        }
        int n = this.bufferPointer + this.contentLength;
        if (n > this.currentMessage.length()) {
            n = this.currentMessage.length();
            string = this.currentMessage.substring(this.bufferPointer, n);
            this.bufferPointer = n;
        } else {
            string = this.currentMessage.substring(this.bufferPointer, n);
            this.bufferPointer = n + 1;
        }
        this.contentLength = 0;
        return string;
    }

    protected byte[] getBodyAsBytes() {
        if (this.contentLength == 0) {
            return null;
        }
        int n = this.bufferPointer + this.contentLength;
        if (n > this.currentMessageBytes.length) {
            n = this.currentMessageBytes.length;
        }
        byte[] byArray = new byte[n - this.bufferPointer];
        System.arraycopy(this.currentMessageBytes, this.bufferPointer, byArray, 0, byArray.length);
        this.bufferPointer = n;
        this.contentLength = 0;
        return byArray;
    }

    protected String readToEnd() {
        String string = this.currentMessage.substring(this.bufferPointer);
        this.bufferPointer += string.length();
        return string;
    }

    protected byte[] readBytesToEnd() {
        byte[] byArray = new byte[this.currentMessageBytes.length - this.bufferPointer];
        int n = this.currentMessageBytes.length;
        int n2 = this.bufferPointer;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = this.currentMessageBytes[n2];
            ++n2;
            ++n3;
        }
        this.bufferPointer = n;
        this.contentLength = 0;
        return byArray;
    }

    public void setParseExceptionListener(ParseExceptionListener parseExceptionListener) {
        this.parseExceptionListener = parseExceptionListener;
    }

    protected boolean isBodyString() {
        return this.bodyIsString;
    }

    public SIPMessage parseSIPMessage(byte[] byArray) throws ParseException {
        String string;
        int n;
        int n2;
        this.bufferPointer = 0;
        this.bodyIsString = false;
        Vector vector = new Vector();
        this.currentMessageBytes = byArray;
        for (n2 = this.bufferPointer; n2 < byArray.length && ((char)byArray[n2] == '\r' || (char)byArray[n2] == '\n' || (char)byArray[n2] == '\u0000'); ++n2) {
        }
        if (n2 == byArray.length) {
            return null;
        }
        for (n = n2; n < byArray.length - 4 && ((char)byArray[n] != '\r' || (char)byArray[n + 1] != '\n' || (char)byArray[n + 2] != '\r' || (char)byArray[n + 3] != '\n'); ++n) {
        }
        if (n < byArray.length) {
            n += 4;
        } else {
            for (n = n2; n < byArray.length - 2 && ((char)byArray[n] != '\n' || (char)byArray[n + 1] != '\n'); ++n) {
            }
            if (n < byArray.length) {
                n += 2;
            } else {
                throw new ParseException("Message not terminated", 0);
            }
        }
        String string2 = null;
        try {
            string2 = new String(byArray, n2, n - n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException("Bad message encoding!", 0);
        }
        this.bufferPointer = n;
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n3 = stringBuffer.length();
        for (int i = 0; i < n3; ++i) {
            if (stringBuffer.charAt(i) != '\r') continue;
            stringBuffer.deleteCharAt(i);
            --n3;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n", true);
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                if (string.trim().equals("")) {
                    stringBuffer2.append("\n");
                    continue;
                }
                stringBuffer2.append(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        string = stringBuffer2.toString();
        n3 = string.indexOf("\n\n") + 2;
        int n4 = 0;
        while (n4 < n3 - 1) {
            if (stringBuffer2.charAt(n4) == '\n') {
                if (stringBuffer2.charAt(n4 + 1) == '\t' || stringBuffer2.charAt(n4 + 1) == ' ') {
                    stringBuffer2.deleteCharAt(n4);
                    stringBuffer2.deleteCharAt(n4);
                    --n3;
                    if (n4 != --n3) continue;
                    break;
                }
                if (stringBuffer2.charAt(n4 + 1) == '\n') {
                    stringBuffer2.insert(n4, '\n');
                    ++n3;
                    ++n4;
                }
            }
            ++n4;
        }
        stringBuffer2.append("\n\n");
        this.currentMessage = stringBuffer2.toString();
        SIPMessage sIPMessage = this.parseMessage(this.currentMessage);
        if (this.readBody && sIPMessage.getContentLength() != null && sIPMessage.getContentLength().getContentLength() != 0) {
            this.contentLength = sIPMessage.getContentLength().getContentLength();
            byte[] byArray2 = this.getBodyAsBytes();
            sIPMessage.setMessageContent(byArray2);
        }
        sIPMessage.setSize(this.currentMessage.length());
        return sIPMessage;
    }

    public SIPMessage parseSIPMessage(String string) throws ParseException {
        int n;
        this.rawMessage = string;
        Vector vector = new Vector();
        String string2 = string.trim();
        this.bodyIsString = true;
        this.contentLength = 0;
        if (string2.trim().equals("")) {
            return null;
        }
        string2 = string2 + "\n\n";
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringBuffer.charAt(0) == '\r' || stringBuffer.charAt(0) == '\n') {
            ++this.bufferPointer;
            stringBuffer.deleteCharAt(0);
        }
        String string3 = stringBuffer.toString();
        int n2 = string3.indexOf("\r\n\r\n");
        if (n2 > 0) {
            n2 += 4;
        }
        if (n2 == -1) {
            n2 = string3.indexOf("\n\n");
            if (n2 == -1) {
                throw new ParseException("no trailing crlf", 0);
            }
        } else {
            n2 += 2;
        }
        for (n = 0; n < n2; ++n) {
            if (stringBuffer.charAt(n) != '\r') continue;
            stringBuffer.deleteCharAt(n);
            --n2;
        }
        if (this.debugFlag) {
            for (n = 0; n < n2; ++n) {
                this.rawMessage1 = this.rawMessage1 + "[" + stringBuffer.charAt(n) + "]";
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n", true);
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            while (stringTokenizer.hasMoreElements()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.trim().equals("")) {
                    stringBuffer2.append("\n");
                    continue;
                }
                stringBuffer2.append(string4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        string3 = stringBuffer2.toString();
        n2 = string3.indexOf("\n\n") + 2;
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (stringBuffer2.charAt(n3) == '\n') {
                if (stringBuffer2.charAt(n3 + 1) == '\t' || stringBuffer2.charAt(n3 + 1) == ' ') {
                    stringBuffer2.deleteCharAt(n3);
                    stringBuffer2.deleteCharAt(n3);
                    --n2;
                    if (n3 != --n2) continue;
                    break;
                }
                if (stringBuffer2.charAt(n3 + 1) == '\n') {
                    stringBuffer2.insert(n3, '\n');
                    ++n2;
                    ++n3;
                }
            }
            ++n3;
        }
        stringBuffer2.append("\n\n");
        this.currentMessage = stringBuffer2.toString();
        this.bufferPointer = this.currentMessage.indexOf("\n\n") + 3;
        SIPMessage sIPMessage = this.parseMessage(this.currentMessage);
        if (this.readBody && sIPMessage.getContentLength() != null && sIPMessage.getContentLength().getContentLength() != 0) {
            this.contentLength = sIPMessage.getContentLength().getContentLength();
            String string5 = this.getMessageBody();
            sIPMessage.setMessageContent(string5);
        }
        return sIPMessage;
    }

    private SIPMessage parseMessage(String string) throws ParseException {
        Object object;
        String string2;
        int n = 0;
        SIPMessage sIPMessage = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        this.messageHeaders = new Vector();
        try {
            while (stringTokenizer.hasMoreElements()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("\n")) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).equals("\n")) break;
                    this.messageHeaders.add(object);
                } else {
                    this.messageHeaders.add(string2);
                }
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.currentLine = 0;
        string2 = this.currentHeader = (String)this.messageHeaders.elementAt(this.currentLine);
        if (!string2.startsWith("SIP/2.0")) {
            sIPMessage = new SIPRequest();
            try {
                object = new RequestLineParser(string2 + "\n").parse();
                ((SIPRequest)sIPMessage).setRequestLine((RequestLine)object);
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(parseException, sIPMessage, class$gov$nist$javax$sip$header$RequestLine == null ? (class$gov$nist$javax$sip$header$RequestLine = StringMsgParser.class$("gov.nist.javax.sip.header.RequestLine")) : class$gov$nist$javax$sip$header$RequestLine, string2, string);
                }
                throw parseException;
            }
        } else {
            sIPMessage = new SIPResponse();
            try {
                object = new StatusLineParser(string2 + "\n").parse();
                ((SIPResponse)sIPMessage).setStatusLine((StatusLine)object);
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(parseException, sIPMessage, class$gov$nist$javax$sip$header$StatusLine == null ? (class$gov$nist$javax$sip$header$StatusLine = StringMsgParser.class$("gov.nist.javax.sip.header.StatusLine")) : class$gov$nist$javax$sip$header$StatusLine, string2, string);
                }
                throw parseException;
            }
        }
        for (int i = 1; i < this.messageHeaders.size(); ++i) {
            String string3 = (String)this.messageHeaders.elementAt(i);
            if (string3 == null || string3.trim().equals("")) continue;
            HeaderParser headerParser = null;
            try {
                headerParser = ParserFactory.createParser(string3 + "\n");
            }
            catch (ParseException parseException) {
                this.parseExceptionListener.handleException(parseException, sIPMessage, null, string3, this.rawMessage);
                continue;
            }
            try {
                SIPHeader sIPHeader = headerParser.parse();
                sIPMessage.attachHeader(sIPHeader, false);
                continue;
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener == null) continue;
                String string4 = Lexer.getHeaderName(string3);
                Class<?> clazz = NameMap.getClassFromName(string4);
                try {
                    if (clazz == null) {
                        clazz = Class.forName("gov.nist.javax.sip.header.ExtensionHeaderImpl");
                    }
                    this.parseExceptionListener.handleException(parseException, sIPMessage, clazz, string3, this.rawMessage);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    InternalErrorHandler.handleException(classNotFoundException);
                }
            }
        }
        return sIPMessage;
    }

    public AddressImpl parseAddress(String string) throws ParseException {
        AddressParser addressParser = new AddressParser(string);
        return addressParser.address();
    }

    public HostPort parseHostPort(String string) throws ParseException {
        Lexer lexer = new Lexer("charLexer", string);
        return new HostNameParser(lexer).hostPort();
    }

    public Host parseHost(String string) throws ParseException {
        Lexer lexer = new Lexer("charLexer", string);
        return new HostNameParser(lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(String string) throws ParseException {
        return new URLParser(string).parseTelephoneNumber();
    }

    public SipUri parseSIPUrl(String string) throws ParseException {
        try {
            return (SipUri)new URLParser(string).parse();
        }
        catch (ClassCastException classCastException) {
            throw new ParseException(string + " Not a SIP URL ", 0);
        }
    }

    public GenericURI parseUrl(String string) throws ParseException {
        return new URLParser(string).parse();
    }

    public SIPHeader parseSIPHeader(String string) throws ParseException {
        string = string + "\n\n";
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        boolean bl = false;
        int n = 0;
        while (string.charAt(n) == '\n' || string.charAt(n) == '\t' || string.charAt(n) == ' ') {
            ++n;
        }
        while (n < string.length()) {
            if (n < string.length() - 1 && string.charAt(n) == '\n' && (string.charAt(n + 1) == '\t' || string.charAt(n + 1) == ' ')) {
                stringBuffer.append(' ');
                ++n;
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        stringBuffer.append('\n');
        HeaderParser headerParser = ParserFactory.createParser(stringBuffer.toString());
        if (headerParser == null) {
            throw new ParseException("could not create parser", 0);
        }
        return headerParser.parse();
    }

    public RequestLine parseSIPRequestLine(String string) throws ParseException {
        string = string + "\n";
        return new RequestLineParser(string).parse();
    }

    public StatusLine parseSIPStatusLine(String string) throws ParseException {
        string = string + "\n";
        return new StatusLineParser(string).parse();
    }

    public String getCurrentHeader() {
        return this.currentHeader;
    }

    public int getCurrentLineNumber() {
        return this.currentLine;
    }

    public static void main(String[] stringArray) throws ParseException {
        String[] stringArray2 = new String[]{"SIP/2.0 200 OK\r\nTo: \"The Little Blister\" <sip:LittleGuy@there.com>;tag=469bc066\r\nFrom: \"The Master Blaster\" <sip:BigGuy@here.com>;tag=11\r\nVia: SIP/2.0/UDP 139.10.134.246:5060;branch=z9hG4bK8b0a86f6_1030c7d18e0_17;received=139.10.134.246\r\nCall-ID: 1030c7d18ae_a97b0b_b@8b0a86f6\r\nCSeq: 1 SUBSCRIBE\r\nContact: <sip:172.16.11.162:5070>\r\nContent-Length: 0\r\n\r\n", "SIP/2.0 180 Ringing\r\nVia: SIP/2.0/UDP 172.18.1.29:5060;branch=z9hG4bK43fc10fb4446d55fc5c8f969607991f4\r\nTo: \"0440\" <sip:0440@212.209.220.131>;tag=2600\r\nFrom: \"Andreas\" <sip:andreas@e-horizon.se>;tag=8524\r\nCall-ID: f51a1851c5f570606140f14c8eb64fd3@172.18.1.29\r\nCSeq: 1 INVITE\r\nMax-Forwards: 70\r\nRecord-Route: <sip:212.209.220.131:5060>\r\nContent-Length: 0\r\n\r\n", "REGISTER sip:nist.gov SIP/2.0\r\nVia: SIP/2.0/UDP 129.6.55.182:14826\r\nMax-Forwards: 70\r\nFrom: <sip:mranga@nist.gov>;tag=6fcd5c7ace8b4a45acf0f0cd539b168b;epid=0d4c418ddf\r\nTo: <sip:mranga@nist.gov>\r\nCall-ID: c5679907eb954a8da9f9dceb282d7230@129.6.55.182\r\nCSeq: 1 REGISTER\r\nContact: <sip:129.6.55.182:14826>;methods=\"INVITE, MESSAGE, INFO, SUBSCRIBE, OPTIONS, BYE, CANCEL, NOTIFY, ACK, REFER\"\r\nUser-Agent: RTC/(Microsoft RTC)\r\nEvent:  registration\r\nAllow-Events: presence\r\nContent-Length: 0\r\n\r\nINVITE sip:littleguy@there.com:5060 SIP/2.0\r\nVia: SIP/2.0/UDP 65.243.118.100:5050\r\nFrom: M. Ranganathan  <sip:M.Ranganathan@sipbakeoff.com>;tag=1234\r\nTo: \"littleguy@there.com\" <sip:littleguy@there.com:5060> \r\nCall-ID: Q2AboBsaGn9!?x6@sipbakeoff.com \r\nCSeq: 1 INVITE \r\nContent-Length: 247\r\n\r\nv=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n"};
        for (int i = 0; i < 20; ++i) {
            class ParserThread
            implements Runnable {
                String[] messages;

                public ParserThread(String[] stringArray) {
                    this.messages = stringArray;
                }

                public void run() {
                    for (int i = 0; i < this.messages.length; ++i) {
                        StringMsgParser stringMsgParser = new StringMsgParser();
                        try {
                            SIPMessage sIPMessage = stringMsgParser.parseSIPMessage(this.messages[i]);
                            System.out.println(" i = " + i + " branchId = " + sIPMessage.getTopmostVia().getBranch());
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            new Thread(new ParserThread(stringArray2)).start();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

