/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

class MessageLog {
    private String message;
    private String source;
    private String destination;
    private long timeStamp;
    private boolean isSender;
    private String firstLine;
    private String statusMessage;
    private String tid;
    private String callId;
    private int debugLine;

    public boolean equals(Object object) {
        if (!(object instanceof MessageLog)) {
            return false;
        }
        MessageLog messageLog = (MessageLog)object;
        return messageLog.message.equals(this.message) && messageLog.timeStamp == this.timeStamp;
    }

    public MessageLog(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8, int n) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = string;
        this.source = string2;
        this.destination = string3;
        try {
            long l = Long.parseLong(string4);
            if (l < 0L) {
                throw new IllegalArgumentException("Bad time stamp ");
            }
            this.timeStamp = l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format " + string4);
        }
        this.isSender = bl;
        this.firstLine = string5;
        this.statusMessage = string6;
        this.tid = string7;
        this.callId = string8;
        this.debugLine = n;
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    public MessageLog(String string, String string2, String string3, long l, boolean bl, String string4, String string5, String string6, String string7, int n) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = string;
        this.source = string2;
        this.destination = string3;
        if (l < 0L) {
            throw new IllegalArgumentException("negative ts");
        }
        this.timeStamp = l;
        this.isSender = bl;
        this.firstLine = string4;
        this.statusMessage = string5;
        this.tid = string6;
        this.callId = string7;
        this.debugLine = n;
    }

    public String flush(long l) {
        String string;
        if (this.statusMessage != null) {
            string = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + (this.timeStamp - l) + "\" \nisSender=\"" + this.isSender + "\" \nstatusMessage=\"" + this.statusMessage + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\">\n";
            string = string + "<![CDATA[";
            string = string + this.message;
            string = string + "]]>\n";
            string = string + "</message>\n";
        } else {
            string = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + (this.timeStamp - l) + "\" \nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\">\n";
            string = string + "<![CDATA[";
            string = string + this.message;
            string = string + "]]>\n";
            string = string + "</message>\n";
        }
        return string;
    }

    public String flush() {
        String string;
        if (this.statusMessage != null) {
            string = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\" \nisSender=\"" + this.isSender + "\" \nstatusMessage=\"" + this.statusMessage + "\" \ntransactionId=\"" + this.tid + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ncallId=\"" + this.callId + "\" \ndebugLine=\"" + this.debugLine + "\" \n>\n";
            string = string + "<![CDATA[";
            string = string + this.message;
            string = string + "]]>\n";
            string = string + "</message>\n";
        } else {
            string = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\" \nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\" \n>\n";
            string = string + "<![CDATA[";
            string = string + this.message;
            string = string + "]]>\n";
            string = string + "</message>\n";
        }
        return string;
    }
}

