/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public abstract class SIPTransaction
extends MessageChannel
implements Transaction {
    protected static final int BASE_TIMER_INTERVAL = 500;
    protected static final int T1 = 1;
    protected static final int T4 = 10;
    protected static final int T2 = 8;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected static final int TIMER_I = 10;
    protected static final int TIMER_K = 10;
    protected static final int TIMER_D = 64;
    protected static final int TIMER_C = 360;
    protected Object applicationData;
    protected SIPResponse lastResponse;
    protected SIPDialog dialog;
    protected boolean isMapped;
    protected boolean isAckSeen;
    protected boolean eventPending;
    protected String transactionId;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    protected MessageChannel encapsulatedChannel;
    protected int peerPort;
    protected InetAddress peerInetAddress;
    protected String peerAddress;
    protected String peerProtocol;
    protected int peerPacketSourcePort;
    protected InetAddress peerPacketSourceAddress;
    private String branch;
    protected String method;
    private int cSeq;
    private TransactionState currentState;
    private int retransmissionTimerLastTickCount;
    private int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private Set eventListeners;
    protected From from;
    protected To to;
    protected Event event;
    protected CallID callId;
    private Object wrapper;
    protected int collectionTime;
    protected TimerTask myTimer;
    protected String toTag;
    protected String fromTag;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        this.sipStack = sIPTransactionStack;
        this.encapsulatedChannel = messageChannel;
        this.peerPort = messageChannel.getPeerPort();
        this.peerAddress = messageChannel.getPeerAddress();
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPacketSourcePort = messageChannel.getPeerPacketSourcePort();
        this.peerPacketSourceAddress = messageChannel.getPeerPacketSourceAddress();
        this.peerProtocol = messageChannel.getPeerProtocol();
        if (this.isReliable()) {
            if (this.encapsulatedChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)this.encapsulatedChannel).useCount;
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("use count for encapsulated channel" + this + " " + ((TLSMessageChannel)this.encapsulatedChannel).useCount);
                }
            } else {
                ++((TCPMessageChannel)this.encapsulatedChannel).useCount;
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("use count for encapsulated channel" + this + " " + ((TCPMessageChannel)this.encapsulatedChannel).useCount);
                }
            }
        }
        this.currentState = null;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = Collections.synchronizedSet(new HashSet());
        this.addEventListener(sIPTransactionStack);
    }

    public void setOriginalRequest(SIPRequest sIPRequest) {
        if (this.originalRequest != null) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = sIPRequest;
        this.method = sIPRequest.getMethod();
        this.from = (From)sIPRequest.getFrom();
        this.to = (To)sIPRequest.getTo();
        this.toTag = this.to.getTag();
        this.fromTag = this.from.getTag();
        this.callId = (CallID)sIPRequest.getCallId();
        this.cSeq = sIPRequest.getCSeq().getSequenceNumber();
        this.event = (Event)sIPRequest.getHeader("Event");
        this.transactionId = sIPRequest.getTransactionId();
        this.originalRequest.setTransaction(this);
        String string = ((Via)sIPRequest.getViaHeaders().getFirst()).getBranch();
        if (string != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Setting Branch id : " + string);
            }
            this.setBranch(string);
        } else {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Branch id is null - compute TID!" + sIPRequest.encode());
            }
            this.setBranch(sIPRequest.getTransactionId());
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        return this.originalRequest;
    }

    public final boolean isInviteTransaction() {
        return this.getMethod().equals("INVITE");
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String string) {
        this.branch = string;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.getOriginalRequest().getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final int getCSeq() {
        return this.cSeq;
    }

    public void setState(TransactionState transactionState) {
        this.currentState = transactionState;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Transaction:setState " + transactionState + " " + this);
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public TransactionState getState() {
        return this.currentState;
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int n) {
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft = Math.min(n, 8);
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int n) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("enableTimeoutTimer " + this + " tickCount " + n + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = n;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (LogWriter.needsLogging && this instanceof SIPClientTransaction) {
            this.sipStack.getLogWriter().logMessage("fireTimer " + this + " retransmissionTicks " + this.retransmissionTimerTicksLeft);
        }
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    public final boolean isTerminated() {
        return this.getState() == TERMINATED_STATE;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerInetAddress;
    }

    protected String getPeerProtocol() {
        return this.peerProtocol;
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public Via getViaHeader() {
        Via via = super.getViaHeader();
        try {
            via.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return via;
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        this.encapsulatedChannel.sendMessage(sIPMessage, this.peerInetAddress, this.peerPort);
    }

    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    public void addEventListener(SIPTransactionEventListener sIPTransactionEventListener) {
        this.eventListeners.add(sIPTransactionEventListener);
    }

    public void removeEventListener(SIPTransactionEventListener sIPTransactionEventListener) {
        this.eventListeners.remove(sIPTransactionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int n) {
        SIPTransactionErrorEvent sIPTransactionErrorEvent = new SIPTransactionErrorEvent(this, n);
        Set set = this.eventListeners;
        synchronized (set) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                SIPTransactionEventListener sIPTransactionEventListener = (SIPTransactionEventListener)iterator.next();
                sIPTransactionEventListener.transactionErrorEvent(sIPTransactionErrorEvent);
            }
        }
        if (n != 3) {
            this.eventListeners.clear();
            this.setState(TransactionState.TERMINATED);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.dialog != null) {
                this.dialog.setState(3);
            }
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(SIPDialog sIPDialog) {
        this.dialog = sIPDialog;
    }

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest sIPRequest) {
        boolean bl = false;
        if (this.getOriginalRequest() == null || this.getOriginalRequest().getMethod().equalsIgnoreCase("CANCEL")) {
            return false;
        }
        ViaList viaList = sIPRequest.getViaHeaders();
        if (viaList != null) {
            Via via = (Via)viaList.getFirst();
            String string = via.getBranch();
            if (string != null && !string.startsWith("z9hG4bK")) {
                string = null;
            }
            if (string != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(string) && via.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    bl = true;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("returning  true");
                    }
                }
            } else {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("testing against " + this.getOriginalRequest());
                }
                if (this.getOriginalRequest().getRequestURI().equals(sIPRequest.getRequestURI()) && this.getOriginalRequest().getTo().equals(sIPRequest.getTo()) && this.getOriginalRequest().getFrom().equals(sIPRequest.getFrom()) && this.getOriginalRequest().getCallId().getCallId().equals(sIPRequest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSequenceNumber() == sIPRequest.getCSeq().getSequenceNumber() && via.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void setRetransmitTimer(int n) {
        throw new UnsupportedOperationException("Feature not supported");
    }

    public void close() {
        this.encapsulatedChannel.close();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Closing " + this.encapsulatedChannel);
        }
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setEventPending() {
        this.eventPending = true;
    }

    public void clearPending() {
        this.eventPending = false;
    }

    public void setApplicationData(Object object) {
        this.applicationData = object;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPort = messageChannel.getPeerPort();
    }

    protected abstract void startTransactionTimer();

    public abstract void processPending();

    class LingerTimer
    extends TimerTask {
        private SIPTransaction transaction;
        private SIPTransactionStack sipStack;

        public LingerTimer(SIPTransaction sIPTransaction2) {
            this.transaction = sIPTransaction2;
            this.sipStack = sIPTransaction2.sipStack;
        }

        public void run() {
            if (this.transaction instanceof SIPClientTransaction) {
                this.transaction.close();
            } else if (this.transaction instanceof ServerTransaction) {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("removing" + this.transaction);
                }
                this.sipStack.removeTransaction(this.transaction);
                if (!this.sipStack.cacheServerConnections && this.transaction.encapsulatedChannel instanceof TCPMessageChannel && --((TCPMessageChannel)this.transaction.encapsulatedChannel).useCount == 0) {
                    this.transaction.close();
                } else if (!this.sipStack.cacheServerConnections && this.transaction.encapsulatedChannel instanceof TLSMessageChannel && --((TLSMessageChannel)this.transaction.encapsulatedChannel).useCount == 0) {
                    this.transaction.close();
                } else if (LogWriter.needsLogging && !this.sipStack.cacheServerConnections && this.transaction.isReliable()) {
                    int n = this.transaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)this.transaction.encapsulatedChannel).useCount : ((TLSMessageChannel)this.transaction.encapsulatedChannel).useCount;
                    this.sipStack.logWriter.logMessage("Use Count = " + n);
                }
            }
        }
    }
}

