/*
 * Decompiled with CFR 0.152.
 */
package custom_nodes;

import custom_nodes.NetworkState;
import java.io.IOException;
import matrix.vrml.MFVec3f;
import shout3d.core.Field;
import shout3d.core.FieldObserver;
import shout3d.core.FloatArrayField;
import shout3d.core.Node;

public class NetworkMFVec3f
extends NetworkState {
    private float[] initialValue = new float[]{0.0f, 0.0f, 0.0f};
    public final FloatArrayField setValue = new FloatArrayField((Node)this, "set_value", 13, this.initialValue);
    public final FloatArrayField valueChanged = new FloatArrayField((Node)this, "value_changed", 13, this.initialValue);

    public NetworkMFVec3f() {
        this.setValue.addFieldObserver((FieldObserver)this, null);
        this.valueChanged.addFieldObserver((FieldObserver)this, null);
    }

    protected void finalize() throws Throwable {
        this.setValue.removeFieldObserver((FieldObserver)this);
        this.valueChanged.removeFieldObserver((FieldObserver)this);
        super.finalize();
    }

    public void onFieldChange(Field theField, Object userData) {
        if (theField == this.setValue) {
            this.update();
            if (this.localCopy.getValue()) {
                this.valueChanged.setValue(this.setValue.getValue());
            }
        } else {
            super.onFieldChange(theField, userData);
        }
    }

    public void handleMessage(String tagName, matrix.vrml.Field data) {
        if (tagName.equals(this.name) && data.getType() == 18) {
            float[][] val = ((MFVec3f)data).getValue();
            float[] newVal = new float[val.length * 3];
            int i = 0;
            while (i < val.length) {
                newVal[3 * i] = val[i][0];
                newVal[3 * i + 1] = val[i][1];
                newVal[3 * i + 2] = val[i][2];
                ++i;
            }
            this.valueChanged.setValue(newVal);
            this.setValue.setValue(newVal);
        }
    }

    public void update() {
        if (this.office == null) {
            return;
        }
        float[] val = this.setValue.getValue();
        float[][] newVal = new float[val.length / 3][3];
        int i = 0;
        while (i < newVal.length) {
            newVal[i][0] = val[i * 3];
            newVal[i][1] = val[i * 3 + 1];
            newVal[i][2] = val[i * 3 + 2];
            ++i;
        }
        MFVec3f value = new MFVec3f(newVal);
        try {
            this.office.sendRealTime(this.name, value, this.echo.getValue());
        }
        catch (IOException e) {
            System.out.println(String.valueOf(this.name) + " error sending value " + e);
        }
    }
}

