/*
 * Decompiled with CFR 0.152.
 */
package custom_nodes;

import custom_nodes.NetworkState;
import matrix.deck.Network;
import matrix.deck.RealTimeConsumer;
import matrix.vrml.SFRotation;
import matrix.vrml.SFVec3f;
import shout3d.core.BooleanField;
import shout3d.core.Field;
import shout3d.core.FloatArrayField;
import shout3d.core.Node;
import shout3d.core.NodeArrayField;
import shout3d.core.Shout3DViewer;
import shout3d.core.StringField;
import shout3d.core.Transform;

public class SharedObject
extends Transform
implements RealTimeConsumer {
    private float[] initPos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] initRot = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    private Node[] initStates = new Node[0];
    public final StringField name = new StringField((Node)this, "name", 0, "");
    public final BooleanField isPilot = new BooleanField((Node)this, "isPilot", 0, false);
    public final BooleanField isAvatar = new BooleanField((Node)this, "isAvatar", 0, false);
    public final FloatArrayField position = new FloatArrayField((Node)this, "position", 12, this.initPos);
    public final FloatArrayField orientation = new FloatArrayField((Node)this, "orientation", 32, this.initRot);
    public final BooleanField isVisible = new BooleanField((Node)this, "isVisible", 0, true);
    public final NodeArrayField states = new NodeArrayField((Node)this, "states", 0, this.initStates);
    protected Network postOffice;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setViewer(Shout3DViewer viewer) {
        super.setViewer(viewer);
        viewer.addRoute((Field)this.position, (Field)this.translation);
        this.translation.setValue(this.position.getValue());
        viewer.addRoute((Field)this.orientation, (Field)this.rotation);
        this.rotation.setValue(this.orientation.getValue());
    }

    public void setNetwork(Network network) {
        this.postOffice = network;
        Node[] stateNodes = this.states.getValue();
        System.out.println(String.valueOf(this.getName()) + " #states " + stateNodes.length);
        int i = 0;
        while (i < stateNodes.length) {
            NetworkState state = (NetworkState)stateNodes[i];
            state.setName(String.valueOf(this.getName()) + "_" + state.getName());
            state.setNetwork(this.postOffice);
            this.postOffice.addConsumer(state);
            ++i;
        }
    }

    public void setName(String name) {
        this.name.setValue(name);
    }

    public String getName() {
        return this.name.getValue();
    }

    public void handleMessage(String tag, matrix.vrml.Field data) {
        if (tag.equals(this.name.getValue())) {
            if (data.getType() == 10) {
                this.position.setValue(((SFVec3f)data).getValue());
            } else if (data.getType() == 6) {
                this.orientation.setValue(((SFRotation)data).getValue());
            } else {
                System.out.println(String.valueOf(this.name.getValue()) + " error wrong field type " + data.getType());
            }
        }
    }

    public void update() {
        System.out.println(String.valueOf(this.name.getValue()) + " got an update message");
        if (this.isAvatar.getValue() && this.isPilot.getValue()) {
            System.out.println(String.valueOf(this.name.getValue()) + " is updating");
            Node[] list = this.states.getValue();
            int i = 0;
            while (i < list.length) {
                ((RealTimeConsumer)list[i]).update();
                ++i;
            }
        }
    }

    public void delete() {
        Node[] list = this.states.getValue();
        int i = 0;
        while (i < list.length) {
            this.postOffice.removeConsumer(((RealTimeConsumer)list[i]).getName());
            ++i;
        }
        this.postOffice = null;
    }
}

