/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import matrix.ControlMessage;
import matrix.Message;
import matrix.RealTimeMessage;
import matrix.UnknownMessageException;

public class Connection {
    private Socket ConSocket = null;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean alive;
    private int buffer = 2048;
    private MessageBuffer msgBuffer;

    public Connection() {
        this.alive = false;
    }

    public Connection(int buffer) {
        this.buffer = buffer;
        this.alive = false;
    }

    public Connection(Socket socks) throws IOException {
        this.open(socks);
    }

    public Connection(Socket socks, int buffer) throws IOException {
        this.buffer = buffer;
        this.open(socks);
    }

    public Connection(String host, int port) throws IOException {
        this.open(host, port);
    }

    public Connection(String host, int port, int buffer) throws IOException {
        this.buffer = buffer;
        this.open(host, port);
    }

    public void open(Socket socks) throws IOException {
        this.close();
        this.ConSocket = socks;
        this.in = new DataInputStream(new BufferedInputStream(this.ConSocket.getInputStream(), this.buffer));
        this.out = new DataOutputStream(new BufferedOutputStream(this.ConSocket.getOutputStream(), this.buffer));
        this.alive = true;
        this.msgBuffer = new MessageBuffer();
    }

    public void open(String host, int port) throws IOException {
        this.open(new Socket(host, port));
    }

    public void close() {
        if (this.msgBuffer != null) {
            this.msgBuffer.stop();
        }
        this.msgBuffer = null;
        this.alive = false;
        try {
            if (this.ConSocket != null) {
                this.in.close();
                this.out.close();
                this.ConSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.ConSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRawMessage(Message msg) throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(msg.getType());
            msg.write(this.out);
            this.out.flush();
        }
    }

    public void sendMessage(Message msg) throws IOException {
        if (msg.getType() == 1) {
            this.sendRawMessage(msg);
        } else {
            this.msgBuffer.put(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Message getMessage() throws IOException {
        void var1_3;
        DataInputStream dataInputStream = this.in;
        synchronized (dataInputStream) {
            Message msg;
            int type = this.in.readInt();
            if (type == 1) {
                msg = new ControlMessage(this.in);
            } else if (type == 2) {
                msg = new RealTimeMessage(this.in);
            } else {
                throw new UnknownMessageException("unknown message type " + type);
            }
        }
        return var1_3;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public InetAddress getInetAddress() {
        if (this.isAlive()) {
            return this.ConSocket.getInetAddress();
        }
        return null;
    }

    public int getPort() {
        if (this.isAlive()) {
            return this.ConSocket.getPort();
        }
        return -1;
    }

    private class MessageBuffer
    implements Runnable {
        private Vector buffer = new Vector(10, 10);
        private Thread runner = new Thread((Runnable)this, "msgBuffer");

        MessageBuffer() {
            this.runner.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (Thread.currentThread() == this.runner) {
                try {
                    Vector vector;
                    if (!this.buffer.isEmpty()) {
                        Message msg;
                        vector = this.buffer;
                        synchronized (vector) {
                            msg = (Message)this.buffer.firstElement();
                            this.buffer.removeElementAt(0);
                        }
                        Connection.this.sendRawMessage(msg);
                        continue;
                    }
                    vector = this.buffer;
                    synchronized (vector) {
                        this.buffer.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    System.out.println("msgBuffer Error " + e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Message msg) {
            Vector vector = this.buffer;
            synchronized (vector) {
                if (!this.buffer.isEmpty()) {
                    Enumeration list = this.buffer.elements();
                    RealTimeMessage rt = (RealTimeMessage)msg;
                    while (list.hasMoreElements()) {
                        RealTimeMessage help = (RealTimeMessage)list.nextElement();
                        if (!help.tag.equals(rt.tag) || help.data.getType() != rt.data.getType()) continue;
                        this.buffer.removeElement(help);
                        break;
                    }
                }
                this.buffer.addElement(msg);
                this.buffer.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.runner = null;
            Vector vector = this.buffer;
            synchronized (vector) {
                this.buffer.notify();
            }
        }
    }
}

