/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import matrix.Message;

public class ControlMessage
extends Message {
    public static final int LOGIN = 100;
    public static final int LOGOUT = 150;
    public static final int OBJADD = 200;
    public static final int OBJDEL = 210;
    public static final int ROOM = 400;
    public static final int UPDATE = 600;
    public static final int MSG = 700;
    public static final int WHOIS = 800;
    public static final int ERROR = 900;
    public static final int TYPE = 1;
    public int command;
    public String name;
    public String arg;

    public ControlMessage() {
    }

    public ControlMessage(int command, String name, String arg) {
        this.command = command;
        this.name = name;
        this.arg = arg;
    }

    public ControlMessage(InputStream in) throws IOException {
        this.read(in);
    }

    public int getType() {
        return 1;
    }

    public synchronized void read(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        this.command = din.readInt();
        this.name = din.readUTF();
        this.arg = din.readUTF();
    }

    public synchronized void write(OutputStream out) throws IOException {
        if (this.name == null || this.arg == null) {
            throw new IOException("Data items are null");
        }
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(this.command);
        dout.writeUTF(this.name);
        dout.writeUTF(this.arg);
    }

    public String toString() {
        return this.command + " " + this.name + " " + this.arg;
    }
}

