/*
 * Decompiled with CFR 0.152.
 */
package matrix.chat;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.io.IOException;
import matrix.chat.ChatFrame;
import matrix.chat.Frontend;
import matrix.deck.Backend;
import matrix.deck.NetworkListener;

public class Chat
extends Applet
implements NetworkListener {
    private static final long serialVersionUID = 1L;
    private Frontend gui;
    private String name;
    private String hostname = null;
    private String startRoom;
    private Backend network;
    private int port = 6666;
    private boolean application = false;

    public void init() {
        try {
            this.network = new Backend(this);
        }
        catch (IOException e) {
            System.err.println("PANIC : can't start Network Backend " + e);
        }
        if (!this.application) {
            String arg = this.getParameter("Port");
            if (arg != null) {
                this.port = Integer.parseInt(arg);
            }
            this.startRoom = this.getParameter("Room");
            arg = this.getParameter("Background");
            if (arg != null) {
                try {
                    this.setBackground(new Color(Integer.valueOf(arg, 16)));
                }
                catch (NumberFormatException e) {}
            } else {
                this.setBackground(new Color(192, 192, 192));
            }
            arg = this.getParameter("Foreground");
            if (arg != null) {
                try {
                    this.setForeground(new Color(Integer.valueOf(arg, 16)));
                }
                catch (NumberFormatException e) {
                    System.err.println("foregroundformat " + e);
                }
            } else {
                this.setForeground(Color.black);
            }
        } else {
            this.setBackground(new Color(192, 192, 192));
            this.setForeground(Color.black);
        }
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.gui = new Frontend(this);
        this.add(this.gui);
        this.validate();
    }

    public void destroy() {
        this.network.disconnect();
        this.network.close();
    }

    public boolean action(Event evt, Object what) {
        if (evt.target == this.gui) {
            String arg = (String)evt.arg;
            if (arg.equals("Connect")) {
                this.name = this.gui.getLoginName();
                if (this.name.equals("")) {
                    this.gui.setStatus("Please enter a user name !");
                    return true;
                }
                if (!this.application) {
                    this.hostname = this.getCodeBase().getHost();
                }
                if (this.hostname.equals("")) {
                    this.hostname = "127.0.0.1";
                }
                this.gui.setStatus("Trying to connect to " + this.hostname);
                try {
                    this.network.connect(this.hostname, this.port, this.name, this.name, this.startRoom);
                }
                catch (IOException e) {
                    this.gui.setStatus("Connecting failed : " + e);
                    this.gui.showLogin();
                    return true;
                }
                this.gui.showRun();
                this.gui.display("DeepMatrix", "connected to " + this.hostname);
                return true;
            }
            if (arg.equals("Disconnect")) {
                this.network.disconnect();
                this.gui.display("DeepMatrix", "disconnected from " + this.hostname);
                return true;
            }
            if (arg.equals("Chat")) {
                if (this.network.isConnected()) {
                    String line = this.gui.getChatInput();
                    if (line.startsWith("/")) {
                        try {
                            this.network.switchRoom(line.substring(1));
                        }
                        catch (IOException e) {
                            System.err.println("IOEx in action : " + e);
                        }
                    } else {
                        try {
                            this.network.sendChatMessage(this.gui.getUser(), line);
                        }
                        catch (IOException e) {
                            System.err.println("IOEx in action : " + e);
                        }
                        this.gui.display(this.name, line);
                    }
                }
                return true;
            }
        }
        return super.action(evt, what);
    }

    public void handleLOGOUT() {
        this.gui.showLogin();
        this.gui.setStatus("Press CONNECT to login !");
    }

    public void handleOBJADD(String name, String url) {
    }

    public void handleOBJDEL(String name) {
    }

    public void handleROOM(String name, String url) {
        this.gui.display("DeepMatrix", "changed to room " + name);
    }

    public void handleMSG(String from, String line) {
        this.gui.display(from, line);
    }

    public void handleWHOIS(String[] users) {
        this.gui.setUsers(users);
    }

    public void handleERROR(String from, String line) {
        this.gui.display("Error", String.valueOf(from) + " " + line);
    }

    public Chat() {
    }

    public Chat(String host, int port) {
        this.port = port;
        this.hostname = host;
        this.application = true;
        ChatFrame window = new ChatFrame(this, "DeepMatrix Chat V1.0");
        window.add(this);
        this.init();
        window.pack();
        window.show();
    }

    public static void main(String[] args) {
        String host = "127.0.0.1";
        int port = 6666;
        int i = 0;
        while (i < args.length) {
            String arg;
            if (!args[i].startsWith("-")) {
                System.err.println("Usage: Chat [-host ahost] [-port aport]");
                return;
            }
            if ((arg = args[i++]).equals("-host")) {
                if (i < args.length) {
                    host = args[i++];
                    continue;
                }
                System.err.println("-host requires a hostname");
                continue;
            }
            if (!arg.equals("-port")) continue;
            if (i < args.length) {
                try {
                    port = Integer.parseInt(args[i++]);
                }
                catch (Exception e) {
                    System.err.println("-port requires numeric argument");
                    port = 6666;
                }
                continue;
            }
            System.err.println("-port requires a portnumber");
        }
        new Chat(host, port);
    }
}

