/*
 * Decompiled with CFR 0.152.
 */
package matrix.chat;

import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.util.StringTokenizer;
import matrix.chat.LoginPanel;
import matrix.chat.RunPanel;

public class Frontend
extends Panel {
    private static final long serialVersionUID = 1L;
    private LoginPanel login;
    private RunPanel run;
    private CardLayout cards;
    private Container parent;

    public Frontend(Container parent) {
        this.parent = parent;
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.cards = new CardLayout();
        this.run = new RunPanel(this);
        this.add(this.run);
        this.login = new LoginPanel(this);
        this.add(this.login);
        this.setLayout(this.cards);
        this.cards.last(this);
    }

    public void showLogin() {
        this.login.Username.setText("");
        this.cards.last(this);
    }

    public void showRun() {
        this.run.Chatinput.setText("");
        this.run.Chatarea.setText("");
        this.run.UserList.delItems(0, this.run.UserList.countItems() - 1);
        this.cards.first(this);
    }

    public String getLoginName() {
        return this.login.Username.getText();
    }

    public void setUsers(String[] names) {
        this.run.UserList.delItems(0, this.run.UserList.countItems() - 1);
        int i = 0;
        while (i < names.length) {
            this.run.UserList.addItem(names[i]);
            ++i;
        }
    }

    public String getUser() {
        String sel = this.run.UserList.getSelectedItem();
        this.run.UserList.deselect(this.run.UserList.getSelectedIndex());
        return sel;
    }

    public String getChatInput() {
        String input = this.run.Chatinput.getText();
        this.run.Chatinput.setText("");
        return input;
    }

    public boolean action(Event e, Object what) {
        if (e.target == this.login.Connect) {
            e.target = this;
            e.arg = "Connect";
            return false;
        }
        if (e.target == this.run.Chatinput) {
            e.target = this;
            e.arg = "Chat";
            return false;
        }
        if (e.target == this.run.Disconnect) {
            e.target = this;
            e.arg = "Disconnect";
            return false;
        }
        return super.action(e, what);
    }

    public void display(String by, String li) {
        String out;
        FontMetrics met = this.run.Chatarea.getFontMetrics(this.run.Chatarea.getFont());
        String help = out = String.valueOf(by) + " :";
        StringTokenizer token = new StringTokenizer(li, " ");
        while (token.hasMoreTokens()) {
            String tok = token.nextToken();
            help = String.valueOf(out) + " " + tok;
            if (met.stringWidth(help) > this.run.Chatarea.size().width - 20) {
                this.run.Chatarea.appendText(String.valueOf(out) + "\n");
                out = "     ";
            }
            out = String.valueOf(out) + " " + tok;
        }
        this.run.Chatarea.appendText(String.valueOf(out) + "\n");
        if (this.run.Chatarea.getText().length() > 31000) {
            this.run.Chatarea.replaceText("", 0, 10000);
        }
    }

    public void setStatus(String line) {
        this.login.Status.setText(line);
    }
}

