/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import matrix.Connection;
import matrix.ControlMessage;
import matrix.RealTimeMessage;
import matrix.deck.Network;
import matrix.deck.NetworkListener;
import matrix.deck.RealTimeConsumer;
import matrix.deck.RealTimeHandler;
import matrix.deck.Viewer;
import matrix.vrml.Field;

public class Backend
implements Network,
Runnable {
    private Connection net = new Connection(4096);
    private RealTimeHandler rtThread = new RealTimeHandler();
    private Thread runner = null;
    private int port = 6666;
    private int clientID;
    private String name;
    private boolean connected = false;
    private Vector listeners = new Vector();

    public Backend() throws IOException {
    }

    public Backend(NetworkListener listener) throws IOException {
        this.addNetworkListener(listener);
    }

    public void connect(String hostname, int port, String name, String passwd, String room) throws IOException {
        if (this.net.isAlive()) {
            throw new IOException("Allready connected to" + this.net.getInetAddress().getHostName());
        }
        this.name = name;
        this.net.open(hostname, port);
        ControlMessage msg = new ControlMessage(700, "", "");
        while (msg.command != 100) {
            msg = (ControlMessage)this.net.getMessage();
        }
        msg.name = name;
        msg.arg = passwd;
        this.net.sendMessage(msg);
        msg = (ControlMessage)this.net.getMessage();
        if (msg.command != 700) {
            throw new IOException("Login failed !");
        }
        this.clientID = Integer.parseInt(msg.arg);
        if (room != null) {
            msg.command = 400;
            msg.name = room;
            msg.arg = "";
            this.net.sendMessage(msg);
        } else {
            msg.command = 700;
            msg.name = name;
            msg.arg = "hello";
            this.net.sendMessage(msg);
        }
        this.runner = new Thread((Runnable)this, "backend");
        this.runner.start();
        this.connected = true;
    }

    public void disconnect() {
        this.connected = false;
        this.clearConsumers();
        if (this.net.isAlive()) {
            try {
                this.net.sendMessage(new ControlMessage(150, this.name, ""));
            }
            catch (IOException e) {
                System.err.println("IOEx in disconnect : " + e);
            }
        } else {
            this.runner = null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void getStates() throws IOException {
        this.net.sendMessage(new ControlMessage(600, "", ""));
    }

    public void sendChatMessage(String to, String line) throws IOException {
        if (to == null) {
            to = "ALL";
        }
        this.net.sendMessage(new ControlMessage(700, to, line));
    }

    public void addSharedObject(String name, String url) throws IOException {
        this.net.sendMessage(new ControlMessage(200, name, url));
    }

    public void deleteSharedObject(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(210, name, ""));
    }

    public void update(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(600, name, ""));
    }

    public void switchRoom(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(400, name, ""));
    }

    public void whois() throws IOException {
        this.net.sendMessage(new ControlMessage(800, "", ""));
    }

    public void addNetworkListener(NetworkListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeNetworkListener(NetworkListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addConsumer(RealTimeConsumer consumer) {
        this.rtThread.addConsumer(consumer);
    }

    public RealTimeConsumer getConsumer(String name) {
        return this.rtThread.getConsumer(name);
    }

    public void removeConsumer(String name) {
        this.rtThread.removeConsumer(name);
    }

    public Enumeration getConsumers() {
        return this.rtThread.getConsumers();
    }

    public void clearConsumers() {
        this.rtThread.clear();
    }

    public void sendRealTime(String tag, Field data, boolean echo) throws IOException {
        this.net.sendMessage(new RealTimeMessage(tag, data, echo));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try lbl-1000:
            // 8 sources

            {
                while (true) {
                    block23: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    if (Thread.currentThread() != this.runner) {
                                                        return;
                                                    }
                                                    try {
                                                        msg = this.net.getMessage();
                                                    }
                                                    catch (InterruptedIOException e) {
                                                        continue;
                                                    }
                                                    if (msg.getType() != 1) break block23;
                                                    cm = (ControlMessage)msg;
                                                    if (cm.command == 600) {
                                                        this.rtThread.update(cm.name);
                                                        continue;
                                                    }
                                                    if (cm.command != 700) break block24;
                                                    if (cm.name.equals(this.name)) continue;
                                                    list = this.listeners.elements();
                                                    if (true) ** GOTO lbl71
                                                }
                                                if (cm.command != 200) break block25;
                                                list = this.listeners.elements();
                                                if (true) ** GOTO lbl75
                                            }
                                            if (cm.command != 210) break block26;
                                            list = this.listeners.elements();
                                            if (true) ** GOTO lbl79
                                        }
                                        if (cm.command != 900) break block27;
                                        list = this.listeners.elements();
                                        if (true) ** GOTO lbl83
                                    }
                                    if (cm.command != 800) break block28;
                                    token = new StringTokenizer(cm.arg, " ");
                                    users = new Vector<String>();
                                    try {
                                        while (token.hasMoreTokens()) {
                                            users.addElement(token.nextToken());
                                        }
                                    }
                                    catch (NoSuchElementException var6_10) {
                                        // empty catch block
                                    }
                                    arg = new String[users.size()];
                                    i = 0;
                                    if (true) ** GOTO lbl88
                                }
                                if (cm.command != 400) break block29;
                                list = this.listeners.elements();
                                if (true) ** GOTO lbl96
                            }
                            if (cm.command != 150) break block30;
                            this.runner = null;
                            list = this.listeners.elements();
                            if (true) ** GOTO lbl100
                        }
                        System.err.println("unrecognized/not handled Message " + cm);
                        continue;
                    }
                    if (msg.getType() == 2) {
                        this.rtThread.handle((RealTimeMessage)msg);
                        continue;
                    }
                    System.err.println("unknown message type " + msg);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                System.err.println("error listening in main loop\n\t" + e);
                this.disconnect();
                list = this.listeners.elements();
                if (true) ** GOTO lbl104
            }
            do {
                ((NetworkListener)list.nextElement()).handleMSG(cm.name, cm.arg);
lbl71:
                // 2 sources

            } while (list.hasMoreElements());
            ** GOTO lbl-1000
            do {
                ((NetworkListener)list.nextElement()).handleOBJADD(cm.name, cm.arg);
lbl75:
                // 2 sources

            } while (list.hasMoreElements());
            ** GOTO lbl-1000
            do {
                ((NetworkListener)list.nextElement()).handleOBJDEL(cm.name);
lbl79:
                // 2 sources

            } while (list.hasMoreElements());
            ** GOTO lbl-1000
            do {
                ((NetworkListener)list.nextElement()).handleERROR(cm.name, cm.arg);
lbl83:
                // 2 sources

            } while (list.hasMoreElements());
            ** GOTO lbl-1000
            do {
                arg[i] = (String)users.elementAt(i);
                ++i;
lbl88:
                // 2 sources

            } while (i < users.size());
            list = this.listeners.elements();
            while (true) {
                if (!list.hasMoreElements()) ** GOTO lbl-1000
                ((NetworkListener)list.nextElement()).handleWHOIS(arg);
            }
            do {
                ((NetworkListener)list.nextElement()).handleROOM(cm.name, cm.arg);
lbl96:
                // 2 sources

            } while (list.hasMoreElements());
            ** GOTO lbl-1000
            do {
                ((NetworkListener)list.nextElement()).handleLOGOUT();
lbl100:
                // 2 sources

            } while (list.hasMoreElements());
            ** continue;
            do {
                ((NetworkListener)list.nextElement()).handleLOGOUT();
lbl104:
                // 2 sources

            } while (list.hasMoreElements());
            return;
        }
        finally {
            this.net.close();
        }
    }

    public void setViewer(Viewer viewer) {
        if (this.rtThread != null) {
            this.rtThread.setViewer(viewer);
        }
    }

    public void close() {
        this.rtThread.close();
    }
}

