/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck;

import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Container;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import matrix.deck.LoginPanel;
import matrix.deck.RunPanel;
import matrix.deck.UserInterface;
import matrix.deck.UserInterfaceListener;

public class Frontend
extends Panel
implements UserInterface {
    private static final long serialVersionUID = 1L;
    private LoginPanel login;
    private RunPanel run;
    private CardLayout cards;
    private String[] urls;
    private String[] profiles;
    private Vector listeners = new Vector();
    private boolean ghost = false;

    public Frontend(Container parent, String[] lines, UserInterfaceListener listener) {
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.cards = new CardLayout();
        this.run = new RunPanel(this);
        this.add(this.run);
        this.login = new LoginPanel(this, lines);
        this.add(this.login);
        this.setLayout(this.cards);
        this.cards.last(this);
        this.addUserInterfaceListener(listener);
    }

    public void showLoginView() {
        this.login.Username.setText("");
        this.login.Url.setText("");
        this.cards.last(this);
        this.ghost = false;
    }

    public void showRunView() {
        this.run.Chatinput.setText("");
        this.run.Chatarea.setText("");
        this.run.remove(this.run.Gesture);
        this.run.Gesture = new Choice();
        this.run.mainLayout.setConstraints(this.run.Gesture, this.run.makeGridCons(10, 11, 5, 1, 20, 0, 2, 10, 1, 1, 1, 0, 0, 0));
        this.run.Gesture.setBackground(this.getBackground());
        this.run.Gesture.setForeground(this.getForeground());
        this.run.add(this.run.Gesture);
        this.run.validate();
        this.run.UserList.delItems(0, this.run.UserList.countItems() - 1);
        this.cards.first(this);
    }

    public void setAvatars(String[] names, String[] urls, String[] profiles) {
        this.urls = urls;
        this.profiles = profiles;
        int i = 0;
        while (i < names.length) {
            this.login.Avatar.addItem(names[i]);
            ++i;
        }
        this.login.Avatar.addItem("Custom");
        i = 0;
        while (i < profiles.length) {
            this.login.Profile.addItem(profiles[i]);
            ++i;
        }
    }

    public void setGestures(String[] names) {
        this.run.remove(this.run.Gesture);
        this.run.Gesture = new Choice();
        this.run.mainLayout.setConstraints(this.run.Gesture, this.run.makeGridCons(10, 11, 5, 1, 20, 0, 2, 10, 1, 1, 1, 0, 0, 0));
        this.run.Gesture.setBackground(this.getBackground());
        this.run.Gesture.setForeground(this.getForeground());
        this.run.add(this.run.Gesture);
        this.run.validate();
        int i = 0;
        while (i < names.length) {
            this.run.Gesture.addItem(names[i]);
            ++i;
        }
    }

    public void setUsers(String[] names) {
        this.run.UserList.delItems(0, this.run.UserList.countItems() - 1);
        int i = 0;
        while (i < names.length) {
            this.run.UserList.addItem(names[i]);
            ++i;
        }
    }

    public void setGhostMode(boolean value) {
        this.ghost = value;
    }

    public boolean action(Event e, Object what) {
        if (e.target == this.login.Connect) {
            String name = this.login.Username.getText();
            String passwd = null;
            String url = this.login.Avatar.getSelectedItem().equals("Custom") ? this.login.Url.getText() : this.urls[this.login.Avatar.getSelectedIndex()];
            String profile = this.profiles[this.login.Profile.getSelectedIndex()];
            Enumeration list = this.listeners.elements();
            while (list.hasMoreElements()) {
                ((UserInterfaceListener)list.nextElement()).handleConnect(name, passwd, url, profile);
            }
            return true;
        }
        if (e.target == this.run.Chatinput) {
            String line = (String)what;
            String user = this.run.UserList.getSelectedItem();
            this.run.Chatinput.setText("");
            this.run.UserList.deselect(this.run.UserList.getSelectedIndex());
            Enumeration list = this.listeners.elements();
            while (list.hasMoreElements()) {
                ((UserInterfaceListener)list.nextElement()).handleChat(line, user);
            }
            return true;
        }
        if (e.target == this.run.Gesture) {
            String gesture = (String)what;
            Enumeration list = this.listeners.elements();
            while (list.hasMoreElements()) {
                ((UserInterfaceListener)list.nextElement()).handleGesture(gesture);
            }
            return true;
        }
        if (e.target == this.run.Ghost) {
            this.ghost = !this.ghost;
            Enumeration list = this.listeners.elements();
            while (list.hasMoreElements()) {
                ((UserInterfaceListener)list.nextElement()).handleGhost(this.ghost);
            }
            return true;
        }
        if (e.target == this.run.Disconnect) {
            Enumeration list = this.listeners.elements();
            while (list.hasMoreElements()) {
                ((UserInterfaceListener)list.nextElement()).handleDisconnect();
            }
            return true;
        }
        return super.action(e, what);
    }

    public synchronized void display(String from, String line) {
        String out;
        FontMetrics met = this.run.Chatarea.getFontMetrics(this.run.Chatarea.getFont());
        String help = out = String.valueOf(from) + " :";
        StringTokenizer token = new StringTokenizer(line, " ");
        while (token.hasMoreTokens()) {
            String tok = token.nextToken();
            help = String.valueOf(out) + " " + tok;
            if (met.stringWidth(help) > this.run.Chatarea.size().width - 20) {
                this.run.Chatarea.appendText(String.valueOf(out) + "\n");
                out = "     ";
            }
            out = String.valueOf(out) + " " + tok;
        }
        this.run.Chatarea.appendText(String.valueOf(out) + "\n");
        if (this.run.Chatarea.getText().length() > 31000) {
            this.run.Chatarea.replaceText("", 0, 10000);
        }
    }

    public void setStatus(String line) {
        this.login.Status.setText(line);
    }

    public void addUserInterfaceListener(UserInterfaceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeUserInterfaceListener(UserInterfaceListener listener) {
        this.listeners.removeElement(listener);
    }
}

