/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import matrix.RealTimeMessage;
import matrix.deck.RealTimeConsumer;
import matrix.deck.Viewer;

public class RealTimeHandler
implements Runnable {
    private Hashtable consumers = new Hashtable();
    private Vector msgs = new Vector();
    private Thread runner = new Thread((Runnable)this, "handler");
    private int count = 0;
    private int lost = 0;
    private Viewer viewer;

    public RealTimeHandler() throws IOException {
        this.runner.start();
    }

    void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Vector vector;
                if (!this.msgs.isEmpty()) {
                    if (this.viewer != null) {
                        this.viewer.beginUpdate();
                    }
                    while (!this.msgs.isEmpty()) {
                        RealTimeMessage recMsg;
                        vector = this.msgs;
                        synchronized (vector) {
                            recMsg = (RealTimeMessage)this.msgs.firstElement();
                            this.msgs.removeElementAt(0);
                        }
                        RealTimeConsumer help = (RealTimeConsumer)this.consumers.get(recMsg.tag);
                        if (help == null) continue;
                        help.handleMessage(recMsg.tag, recMsg.data);
                    }
                    if (this.viewer == null) continue;
                    this.viewer.endUpdate();
                    continue;
                }
                vector = this.msgs;
                synchronized (vector) {
                    this.msgs.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                System.err.println("RTHandler " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RealTimeMessage msg) {
        Vector vector = this.msgs;
        synchronized (vector) {
            if (!this.msgs.isEmpty()) {
                Enumeration list = this.msgs.elements();
                while (list.hasMoreElements()) {
                    RealTimeMessage help = (RealTimeMessage)list.nextElement();
                    if (!help.tag.equals(msg.tag) || help.data.getType() != msg.data.getType()) continue;
                    this.msgs.removeElement(help);
                    ++this.lost;
                    break;
                }
            }
            this.msgs.addElement(msg);
            this.msgs.notify();
        }
        ++this.count;
        if (this.count == 100) {
            this.count = 0;
            this.lost = 0;
        }
    }

    public synchronized void addConsumer(RealTimeConsumer customer) {
        if (this.consumers.containsKey(customer.getName())) {
            System.err.println("RTHandler " + customer.getName() + " exists allready");
            return;
        }
        this.consumers.put(customer.getName(), customer);
    }

    public RealTimeConsumer getConsumer(String name) {
        return (RealTimeConsumer)this.consumers.get(name);
    }

    public synchronized void removeConsumer(String name) {
        RealTimeConsumer help = (RealTimeConsumer)this.consumers.get(name);
        if (help != null) {
            help.delete();
            this.consumers.remove(name);
        }
    }

    public Enumeration getConsumers() {
        return this.consumers.elements();
    }

    public void update() {
        Enumeration list = this.getConsumers();
        while (list.hasMoreElements()) {
            ((RealTimeConsumer)list.nextElement()).update();
        }
    }

    public void update(String name) {
        RealTimeConsumer help = (RealTimeConsumer)this.consumers.get(name);
        if (help != null) {
            help.update();
        }
    }

    public synchronized void clear() {
        Enumeration list = this.consumers.keys();
        while (list.hasMoreElements()) {
            String help = (String)list.nextElement();
            this.removeConsumer(help);
            list = this.consumers.keys();
        }
        this.consumers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.runner = null;
        Vector vector = this.msgs;
        synchronized (vector) {
            this.msgs.notify();
        }
    }
}

