/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck.eai;

import java.applet.Applet;
import java.awt.Color;
import java.awt.GridLayout;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import matrix.deck.Backend;
import matrix.deck.ConsumerException;
import matrix.deck.Frontend;
import matrix.deck.NetworkListener;
import matrix.deck.SharedObject;
import matrix.deck.UserInterfaceListener;
import matrix.deck.ViewerListener;
import matrix.deck.eai.Avatar;
import matrix.deck.eai.EAIViewer;
import matrix.deck.eai.SO;
import matrix.deck.eai.UserAvatar;
import matrix.deck.eai.WorldObject;

public class Beta
extends Applet
implements NetworkListener,
UserInterfaceListener,
ViewerListener {
    private Frontend gui;
    private EAIViewer viewer;
    private boolean finished = false;
    private WorldObject world;
    private Vector objects = new Vector();
    private String startRoom;
    private String name;
    private String hostname;
    private String avatarUrl;
    private String profile;
    private Backend network;
    private int port = 6666;
    private int vpIndex = -1;
    private UserAvatar avatar;
    private boolean oobe = false;
    private static String[][] substitution = new String[][]{{"%7C", "|"}, {"%20", " "}};

    public void init() {
        try {
            this.network = new Backend(this);
        }
        catch (IOException e) {
            System.err.println("PANIC : can't start Network Backend " + e);
        }
        try {
            Class.forName("matrix.deck.eai.Avatar");
            Class.forName("matrix.deck.eai.Route");
            Class.forName("matrix.deck.ConsumerException");
            Class.forName("matrix.deck.eai.UserAvatar");
            Class.forName("matrix.deck.eai.Gate");
            Class.forName("matrix.vrml.Field");
            Class.forName("matrix.vrml.FieldInputStream");
            Class.forName("matrix.vrml.FieldOutputStream");
        }
        catch (ClassNotFoundException e) {
            System.err.println("PANIC : cl workaround can't load class definitions " + e);
        }
        this.hostname = this.getCodeBase().getHost();
        if (this.hostname.equals("")) {
            this.hostname = "127.0.0.1";
        }
        this.setBackground(new Color(192, 192, 192));
        this.setForeground(Color.black);
        String arg = this.getParameter("Port");
        if (arg != null) {
            this.port = Integer.parseInt(arg);
        }
        if ((arg = this.getParameter("Background")) != null) {
            try {
                this.setBackground(new Color(Integer.valueOf(arg, 16)));
            }
            catch (NumberFormatException e) {
                System.err.println("backgroundformat " + e);
            }
        }
        if ((arg = this.getParameter("Foreground")) != null) {
            try {
                this.setForeground(new Color(Integer.valueOf(arg, 16)));
            }
            catch (NumberFormatException e) {
                System.err.println("foregroundformat " + e);
            }
        }
        this.startRoom = this.getParameter("Room");
        int i = 1;
        Vector<String> names = new Vector<String>();
        Vector<String> urls = new Vector<String>();
        Vector<String> profiles = new Vector<String>();
        String av = this.getParameter("Avatar" + i);
        String avUrl = this.getParameter("AvatarUrl" + i);
        String profile = this.getParameter("Profile" + i);
        while (profile != null) {
            profiles.addElement(profile);
            profile = this.getParameter("Profile" + ++i);
        }
        while (av != null && avUrl != null) {
            names.addElement(av);
            urls.addElement(avUrl);
            av = this.getParameter("Avatar" + ++i);
            avUrl = this.getParameter("AvatarUrl" + i);
        }
        Vector<String> lines = new Vector<String>();
        String[] liness = null;
        i = 1;
        av = this.getParameter("Line" + i);
        while (av != null) {
            lines.addElement(av);
            av = this.getParameter("Line" + ++i);
        }
        if (lines.size() > 0) {
            liness = new String[lines.size()];
            i = 0;
            while (i < lines.size()) {
                liness[i] = (String)lines.elementAt(i);
                ++i;
            }
        }
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.gui = new Frontend(this, liness, this);
        this.add(this.gui);
        String[] h1 = new String[names.size()];
        String[] h2 = new String[urls.size()];
        String[] h3 = new String[profiles.size()];
        i = 0;
        while (i < h1.length) {
            h1[i] = (String)names.elementAt(i);
            h2[i] = (String)urls.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < h3.length) {
            h3[i] = (String)profiles.elementAt(i);
            ++i;
        }
        this.gui.setAvatars(h1, h2, h3);
        this.validate();
    }

    public void start() {
        try {
            this.viewer = new EAIViewer(this);
            this.network.setViewer(this.viewer);
        }
        catch (Exception e) {
            System.out.println("Exception getting viewer : " + e);
            this.gui.setStatus("Error making connection to VRML !");
            this.viewer = null;
            return;
        }
        this.viewer.addViewerListener(this);
        this.viewer.start();
    }

    public void stop() {
        this.network.disconnect();
        this.network.close();
    }

    public void handleConnect(String loginName, String password, String avatarUrl, String chosenProfile) {
        if (this.viewer == null) {
            return;
        }
        this.name = loginName;
        this.profile = chosenProfile;
        this.avatarUrl = avatarUrl;
        if (loginName.equals("")) {
            this.gui.setStatus("Please enter a user name !");
            return;
        }
        this.gui.setStatus("Trying to connect to " + this.hostname);
        try {
            this.network.connect(this.hostname, this.port, loginName, loginName, this.startRoom);
        }
        catch (IOException e) {
            this.gui.setStatus("Connecting failed : " + e);
            this.gui.showLoginView();
            return;
        }
        this.gui.showRunView();
        this.gui.display("Matrix", "connected to " + this.hostname);
    }

    public void handleChat(String line, String to) {
        if (this.network.isConnected()) {
            try {
                this.network.sendChatMessage(to, line);
            }
            catch (IOException e) {
                System.err.println("IOEx in handleChat : " + e);
            }
            this.gui.display(this.name, line);
        }
    }

    public void handleGesture(String gesture) {
        if (this.avatar != null) {
            this.avatar.trigger(gesture);
        }
    }

    public void handleGhost(boolean value) {
        if (this.avatar != null) {
            if (!value) {
                this.avatar.hide();
            } else {
                this.avatar.show();
            }
        }
    }

    public void handleDisconnect() {
        if (this.avatar != null) {
            try {
                this.network.deleteSharedObject(this.avatar.getName());
                this.network.removeConsumer(this.avatar.getName());
            }
            catch (IOException e) {
                System.err.println("IOEx deleting avatar " + e);
            }
        }
        this.network.disconnect();
    }

    public void handleLOGOUT() {
        this.viewer.reset();
        this.network.clearConsumers();
        this.world = null;
        this.gui.display("Matrix", "disconnected from " + this.hostname);
        this.gui.showLoginView();
        this.gui.setStatus("Press CONNECT to login !");
    }

    public void handleOBJADD(String name, String url) {
        if (this.finished) {
            this.viewer.addSharedObject(name, this.generateUrl(url));
        } else {
            String[] tt = new String[]{name, this.generateUrl(url)};
            this.objects.addElement(tt);
        }
    }

    public void handleOBJDEL(String name) {
        this.network.removeConsumer(name);
        this.viewer.removeSharedObject(name);
        System.out.println("Object " + name + " removed");
    }

    public void handleROOM(String name, String url) {
        System.out.println("ROOM start");
        this.finished = false;
        url = this.generateUrl(url);
        this.gui.display("Matrix", "loading room " + name + " ( " + url + " )");
        this.viewer.reset();
        this.network.clearConsumers();
        this.world = null;
        this.avatar = null;
        this.viewer.loadWorld("world", this.generateUrl(url));
        System.out.println("Loading room " + name + " " + url);
    }

    public void handleMSG(String from, String line) {
        this.gui.display(from, line);
    }

    public void handleWHOIS(String[] users) {
        this.gui.setUsers(users);
    }

    public void handleERROR(String from, String line) {
        this.gui.display("Error", String.valueOf(from) + " " + line);
    }

    public void onWorldLoaded(String name, SharedObject object) {
        if (object == null) {
            System.out.println("Error loading world !");
            this.gui.display("Matrix", "could not load the world - disconnecting");
            this.network.disconnect();
            return;
        }
        this.avatar = null;
        try {
            this.world = new WorldObject((SO)object, this.viewer.getBrowser(), this.network, this, this.vpIndex);
        }
        catch (ConsumerException e) {
            this.gui.display("Matrix", e.toString());
            this.network.disconnect();
            return;
        }
        this.network.addConsumer(this.world);
        this.finished = true;
        this.gui.display("Matrix", "world loaded !");
        System.out.println("World loaded.");
        try {
            this.network.update("world");
        }
        catch (IOException e) {
            System.out.println("Error updating world " + e);
        }
        if (this.avatarUrl != null) {
            try {
                this.network.addSharedObject("_" + this.name, this.avatarUrl);
                this.handleOBJADD("_" + this.name, this.generateUrl(this.avatarUrl));
                this.gui.display("Matrix", "loading Avatar");
            }
            catch (IOException e) {
                System.out.println("error adding user avatar " + e);
            }
        }
        Enumeration objs = this.objects.elements();
        while (objs.hasMoreElements()) {
            String[] tt = (String[])objs.nextElement();
            this.viewer.addSharedObject(tt[0], tt[1]);
        }
        this.objects.removeAllElements();
        this.gui.display("Matrix", "loaded shared objects.");
        System.out.println("loaded shared objects");
    }

    public void onObjectLoaded(String name, SharedObject object) {
        if (object != null) {
            if (name.equals("_" + this.name)) {
                this.avatar = new UserAvatar((SO)object, this.network, this.viewer.getBrowser(), this.world.getProxy(), this);
                this.network.addConsumer(this.avatar);
                this.avatar.setOffset(this.world.getOffset());
            } else {
                Avatar av = new Avatar((SO)object, this.viewer.getBrowser(), this.network);
                this.network.addConsumer(av);
                try {
                    this.network.update(av.getName());
                }
                catch (IOException e) {
                    System.out.println("Error updating " + av.getName() + " " + e);
                }
            }
            System.out.println("Object " + name + " loaded.");
        } else {
            System.out.println("Error loading object " + name + " !");
        }
    }

    void gateFired(String target) {
        try {
            if (this.avatar != null) {
                this.network.deleteSharedObject(this.avatar.getName());
            }
            this.finished = false;
            this.network.switchRoom(target);
        }
        catch (IOException e) {
            System.err.println("Ex in gate callback " + e);
        }
    }

    public void addBehavs(String[] behavs) {
        this.gui.setGestures(behavs);
    }

    String generateUrl(String url) {
        URL help;
        try {
            help = new URL(this.getDocumentBase(), url);
        }
        catch (MalformedURLException e) {
            System.err.println("URLException " + e);
            return url;
        }
        String hs = help.toExternalForm();
        int i = 0;
        while (i < substitution.length) {
            int ind;
            while ((ind = hs.indexOf(substitution[i][0])) > -1) {
                hs = String.valueOf(hs.substring(0, ind)) + substitution[i][1] + hs.substring(ind + 3);
            }
            ++i;
        }
        return hs;
    }

    String readUrl(String url) throws Exception {
        StringBuffer content = new StringBuffer();
        url = this.generateUrl(url);
        System.out.println("Reading file from " + url + " ...");
        URL contentUrl = new URL(url);
        DataInputStream s = new DataInputStream(contentUrl.openStream());
        String line = s.readLine();
        while (line != null) {
            content.append(String.valueOf(line) + "\n");
            line = s.readLine();
        }
        s.close();
        return content.toString();
    }
}

