/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck.eai;

import java.applet.Applet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import matrix.deck.SharedObject;
import matrix.deck.Viewer;
import matrix.deck.ViewerListener;
import matrix.deck.eai.SO;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.field.EventInMFNode;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutMFNode;
import vrml.external.field.EventOutObserver;

public class EAIViewer
implements Viewer,
Runnable {
    private Browser browser = null;
    private boolean updateOk = false;
    private Node rootNode;
    private EventInMFNode addChildren;
    private EventInMFNode removeChildren;
    private EventInMFNode setChildren;
    private EventOutMFNode childrenChanged;
    private Vector listeners = new Vector();
    private Thread runner;
    private String worldName;
    Vector observers = new Vector();
    Vector loaded = new Vector();
    Hashtable objects = new Hashtable();

    public EAIViewer(Applet applet) throws Exception {
        while (this.browser == null) {
            try {
                this.browser = Browser.getBrowser((Applet)applet);
            }
            catch (NullPointerException e) {
                System.err.println("No browser pointer " + e);
            }
        }
        if (this.browser == null) {
            throw new Exception("EAIViewer : Didn't get browser pointer");
        }
        try {
            String name = this.browser.getName().toLowerCase();
            if (name.indexOf("blaxxun") >= 0 || name.indexOf("cortona") >= 0) {
                this.updateOk = true;
            }
            this.rootNode = this.browser.getNode("ROOT");
            this.addChildren = (EventInMFNode)this.rootNode.getEventIn("addChildren");
            this.removeChildren = (EventInMFNode)this.rootNode.getEventIn("removeChildren");
            this.setChildren = (EventInMFNode)this.rootNode.getEventIn("set_children");
            this.childrenChanged = (EventOutMFNode)this.rootNode.getEventOut("children_changed");
        }
        catch (Exception e) {
            throw new Exception("EAIViewer : " + e);
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void stop() {
        this.runner = null;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ** GOTO lbl28
        {
            obs = (LoadObserver)this.loaded.firstElement();
            object = obs.object;
            this.loaded.removeElementAt(0);
            if (obs.success) {
                this.objects.put(object.getName(), object);
                if (object.getName().equals(this.worldName)) {
                    this.setChildren.setValue(new Node[]{object.getTransform()});
                    this.onWorldLoaded(object.getName(), object);
                    this.worldName = null;
                } else {
                    this.addChildren.setValue(new Node[]{object.getTransform()});
                    this.onObjectLoaded(object.getName(), object);
                }
            } else if (object.getName().equals(this.worldName)) {
                this.onWorldLoaded(object.getName(), null);
                this.worldName = null;
            } else {
                this.onObjectLoaded(object.getName(), null);
            }
            do {
                if (!this.loaded.isEmpty()) continue block2;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
lbl28:
                // 3 sources

            } while (Thread.currentThread() == this.runner);
        }
    }

    public void reset() {
        this.objects.clear();
        this.removeChildren.setValue(this.childrenChanged.getValue());
    }

    public void loadWorld(String name, String url) {
        System.out.println("EAIViewer : world " + name + " " + url);
        this.worldName = name;
        this.addSharedObject(name, url);
    }

    public void addSharedObject(String name, String url) {
        LoadObserver lo;
        System.out.println("EAIViewer : object " + name + " " + url);
        Node[] help = this.browser.createVrmlFromString("Group{}");
        SO object = new SO(name, help[0]);
        try {
            lo = new LoadObserver(object);
        }
        catch (Exception e) {
            System.out.println("EAIViewer : error loading object " + name + " " + e);
            return;
        }
        this.observers.addElement(lo);
        this.browser.createVrmlFromURL(new String[]{url}, help[0], "addChildren");
    }

    public void removeSharedObject(String name) {
        SO object = (SO)this.objects.remove(name);
        if (object != null) {
            this.removeChildren.setValue(new Node[]{object.getTransform()});
        }
    }

    public void addViewerListener(ViewerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeViewerListener(ViewerListener listener) {
        this.listeners.removeElement(listener);
    }

    public void beginUpdate() {
        if (this.updateOk) {
            this.browser.beginUpdate();
        }
    }

    public void endUpdate() {
        if (this.updateOk) {
            this.browser.endUpdate();
        }
    }

    private void onWorldLoaded(String name, SharedObject object) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ((ViewerListener)list.nextElement()).onWorldLoaded(name, object);
        }
    }

    private void onObjectLoaded(String name, SharedObject object) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ((ViewerListener)list.nextElement()).onObjectLoaded(name, object);
        }
    }

    class LoadObserver
    implements EventOutObserver {
        private boolean loadFlag = false;
        boolean success = false;
        SO object;

        public LoadObserver(SO so) throws Exception {
            this.object = so;
            this.object.getTransform().getEventOut("children_changed").advise((EventOutObserver)this, (Object)new Integer(0));
        }

        public void callback(EventOut value, double time, Object data) {
            if (!this.loadFlag) {
                if (((EventOutMFNode)value).getValue().length == 0) {
                    System.out.println("EAIViewer : couldn't load " + this.object.getName());
                    this.success = false;
                    EAIViewer.this.loaded.addElement(this);
                } else {
                    this.success = true;
                    EAIViewer.this.loaded.addElement(this);
                }
                EAIViewer.this.observers.removeElement(this);
                this.loadFlag = true;
            } else {
                System.out.println(String.valueOf(this.object.getName()) + " got called again " + ((EventOutMFNode)value).getValue().length);
            }
        }
    }
}

